<?php

namespace evApps\Updater\Ds\App\Controllers;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use GuzzleHttp\Client;
use League\Flysystem\Config;
use Mockery\Exception;
use Ifsnop\Mysqldump as IMysqldump;
use ZipArchive;


class UpdatesController extends Controller
{

    public function index()
    {
        if(\Auth::user()->can(\App\Models\PermissionManager\Permission::FULL_ACCESS)) {
            $data['last_backup'] = $this->checkBackupVersion();

            return view('updater::index', $data);
        } else {
            Abort(403);
        }
    }

    public function updatesInstall()
    {
        if(\Auth::user()->can(\App\Models\PermissionManager\Permission::FULL_ACCESS)) {
            $route ='/updater/get-updates/ds.update.zip';
            $this->install($route);
        } else {
            Abort(403);
        }
    }

    public function testInstall(){
        if(\Auth::user()->can(\App\Models\PermissionManager\Permission::FULL_ACCESS)) {
            $route ='/updater/get-test-updates/ds.update.zip';
            $this->install($route);
        } else {
            Abort(403);
        }
    }

    public function backup()
    {
        if(\Auth::user()->can(\App\Models\PermissionManager\Permission::FULL_ACCESS)) {
            $updates = storage_path('app/' . config('app.name'));
            if (!\File::isDirectory($updates)) {
                \File::makeDirectory($updates, 0755, true, true);
            } else {
                \File::cleanDirectory($updates);
            }
            \Artisan::call('backup:run', ['--only-files' => true, '--disable-notifications' => true]);
            try {
                $dump = new IMysqldump\Mysqldump('mysql:host=' . config('database.connections.mysql.host') . ';dbname=' . config('database.connections.mysql.database'), config('database.connections.mysql.username'), config('database.connections.mysql.password'));
                $dump->start($updates . '/' . date('Y-m-d-H-i-s') . '.sql');
            } catch (\Exception $e) {
                return response()->json(['message' => 'mysqldump-php error'], 403);
            }
            \File::deleteDirectory(storage_path('app/backup-temp'));
            $data['last_backup'] = $this->checkBackupVersion();
            return response()->json($data, 200);
        } else {
            Abort(403);
        }
    }

    protected function checkBackupVersion()
    {
        $backup = storage_path('app/' . config('app.name'));
        $files = '';
        $lastBackup = null;
        if(\File::isDirectory($backup)) {
            $files = \File::allFiles($backup);
        }
        if($files) {
            foreach ($files as $file) {
                if ($file->getExtension() == 'sql') {
                    $lastBackup = Carbon::createFromFormat('Y-m-d-H-i-s', $file->getBasename('.' . $file->getExtension()))->timezone('Europe/Moscow')->toDateTimeString();
                }
            }
        }

        return $lastBackup;
    }

    protected function install($route){
        $client = new Client([
            'base_uri' => env('APP_LICENSE_SERVER'),
            'verify' => false
        ]);

        $headers = [
            'Accept' => 'application/json',
            'Content-Type' => 'application/json',
            'App-Licence-Key' => md5(env('APP_LICENSE_KEY'))
        ];
        try {
            $result = $client->request('GET', $route, [
                'headers' => $headers
            ]);
        } catch (Exception $e) {
            return response()->json([], $e->getCode());
        }
        if ($result->getStatusCode() == 200) {
            $data = $result->getBody();
            $path = 'temp-' . md5(mt_rand());
            \File::cleanDirectory(storage_path('app/temp'));
            $temp_path = storage_path('app/temp') . '/' . $path;

            if (!\File::isDirectory($temp_path)) {
                \File::makeDirectory($temp_path, 0755, true, true);
            }

            $file = $temp_path . '/upload.zip';

            // Add content to the Zip file
            $uploaded = is_int(file_put_contents($file, $data)) ? true : false;

            if (!$uploaded) {
                return response()->json(['message' => 'Save'], 403);
            }

            // Unzip the file
            $zip = new ZipArchive();

            if (!$zip->open($file) || !$zip->extractTo($temp_path)) {
                return response()->json(['message' => 'Extract'], 403);
            }

            $zip->close();

            // Delete zip file
            \File::delete($file);

            if (!\File::copyDirectory($temp_path, base_path())) {
                return response()->json(['message' => 'Rewrite'], 403);
            } else {
                if(\File::deleteDirectory(storage_path('app/temp'))) {
                    \Artisan::call('migrate', ['--force' => true]);
                    \Artisan::call('view:clear', ['--no-interaction' => true]);
                    \Artisan::call('cache:clear', ['--no-interaction' => true]);
                    \Artisan::call('config:clear', ['--no-interaction' => true]);
                    \Artisan::call('route:clear', ['--no-interaction' => true]);

                    return response()->json(['message' => 'Success'], 200);
                } else {
                    return response()->json(['message' => 'Remove temp'], 403);
                }
            }

        }
    }
}
