@extends('installer::layout', [
    'title' => __('installer::database.step_title'),
    'showPreviousStepButton' => true,
    'previousStepName' => \evApps\Installer\app\Http\Utilities\Installer::LICENSE_KEY_STEP,
])

@php
$db = [
    'dbConnection' => old('dbConnection') ? old('dbConnection') : env('DB_CONNECTION'),
    'dbHost' => old('dbHost') ? old('dbHost') : (env('DB_HOST') ? env('DB_HOST') : 'localhost'),
    'dbPort' => old('dbPort') ? old('dbPort') : (env('DB_PORT') ? env('DB_PORT') : '3306'),
    'dbName' => old('dbName') ? old('dbName') : (env('DB_DATABASE') ? env('DB_DATABASE') : 'tnect'),
    'dbUserName' => old('dbUserName') ? old('dbUserName') : env('DB_USERNAME'),
];
@endphp

@section('content')
    <div class="form-group">
        <label for="dbConnection">@lang('installer::database.dbConnection')</label>
        <input type="hidden" name="dbConnection" value="{{ \evApps\Installer\app\Http\Utilities\Installer::DB_CONNECTION_MYSQL }}">
        <input type="text" readonly class="form-control-plaintext" value="MySQL">
    </div>

    <div class="form-group">
        <label for="dbHost">@lang('installer::database.dbHost')</label>
        <input type="text" name="dbHost" required class="form-control" id="dbHost" placeholder="localhost" value="{{ $db['dbHost'] }}">
    </div>

    <div class="form-group">
        <label for="dbPort">@lang('installer::database.dbPort')</label>
        <input type="number" name="dbPort" required class="form-control" id="dbPort" placeholder="3306" value="{{ $db['dbPort'] }}">
    </div>

    <div class="form-group">
        <label for="dbName">@lang('installer::database.dbName')</label>
        <input type="text" name="dbName" required class="form-control" id="dbName" placeholder="trueip" value="{{ $db['dbName'] }}">
    </div>

    <div class="form-group">
        <label for="dbUserName">@lang('installer::database.dbUserName')</label>
        <input type="text" name="dbUserName" required class="form-control" id="dbUserName" value="{{ $db['dbUserName'] }}">
    </div>

    <div class="form-group">
        <label for="dbPassword">@lang('installer::database.dbPassword')</label>
        <input type="password" name="dbPassword" required class="form-control" id="dbPassword">
    </div>
@endsection
