<?php

namespace evApps\Installer\app\Http\Utilities;

use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;

/**
 * Class DatabaseChecker
 *
 * @package evApps\Installer\app\Http\Utilities
 */
class DatabaseChecker
{

    const MIN_SERVER_VERSION = '5.7.0';

    /**
     * Check if the database exists and is accessible.
     *
     * @param string $driver
     * @param string $host
     * @param string $port
     * @param string $database
     * @param string $username
     * @param string $password
     *
     * @return bool
     * @throws \Exception
     */
    public static function isDbValid(
        string $driver,
        string $host,
        string $port,
        string $database,
        string $username,
        string $password
    )
    {
        Config::set('database.connections.evapps_installer_test', [
            'host' => $host,
            'port' => $port,
            'database' => $database,
            'username' => $username,
            'password' => $password,
            'driver' => $driver,
            'charset' => env('DB_CHARSET', 'utf8mb4'),
        ]);

        try {
            /** @var \Doctrine\DBAL\Driver\PDOConnection $pdo */
            $pdo = DB::connection('evapps_installer_test')->getPdo();
            $serverVersion = $pdo->getServerVersion();
        } catch (\Exception $e) {;
            throw new \Exception(__('installer::database.database_not_valid'));
        }

        // Purge test connection
        DB::purge('evapps_installer_test');

        if ($serverVersion < self::MIN_SERVER_VERSION) {
            throw new \Exception(__(
                'installer::database.server_not_supported', [
                    'version' => $serverVersion,
                ]
            ));
        }

        return true;
    }
}
