<?php

namespace evApps\Installer\app\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Class FirstObjectRequest
 *
 * @package evApps\Installer\app\Http\Requests
 */
class FirstObjectRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|string|min:3|max:100',
            'address' => 'required|string|min:3|max:255',
            'sip_server_address' => 'required|max:255',
            'sip_server_port' => 'nullable|numeric',
            'concierge_sip_number' => 'required|numeric',
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'name' => __('installer::database.name'),
            'address' => __('installer::database.address'),
            'sip_server_address' => __('installer::database.sip_server_address'),
            'sip_server_port' => __('installer::database.sip_server_port'),
            'concierge_sip_number' => __('installer::database.concierge_sip_number'),
        ];
    }
}
