<?php

namespace evApps\Installer\app\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Class DatabaseRequest
 *
 * @package evApps\Installer\app\Http\Requests
 */
class DatabaseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'dbHost' => 'required|string',
            'dbPort' => 'required|string',
            'dbName' => 'required|string',
            'dbUserName' => 'required|string',
            'dbPassword' => 'required|string',
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'dbHost' => __('installer::database.dbHost'),
            'dbPort' => __('installer::database.dbPort'),
            'dbName' => __('installer::database.dbName'),
            'dbUserName' => __('installer::database.dbUserName'),
            'dbPassword' => __('installer::database.dbPassword'),
        ];
    }
}
