<?php

namespace evApps\Installer\app\Http\Middleware;

use App;
use Closure;
use Config;

/**
 * Class Locale
 *
 * @package evApps\Installer\app\Http\Middleware
 */
class Locale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $localeFromCookie = $request->cookie('locale');

        if (in_array($localeFromCookie, Config::get('evapps.installer.locales'))) {
            $locale = $localeFromCookie;
        } else {
            $locale = Config::get('evapps.installer.locale');
        }

        App::setLocale($locale);

        return $next($request);
    }
}
