<?php

namespace evApps\Installer\app\Http\Middleware;

use Closure;
use evApps\Installer\app\Http\Utilities\Installer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;

/**
 * Class IsNotAlreadyInstalled
 *
 * @package evApps\Installer\app\Http\Middleware
 */
class IsNotAlreadyInstalled
{


    /**
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     *
     * @return \Illuminate\Http\RedirectResponse|mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if (Installer::isAlreadyInstalled()) {
            // Redirect to home page
            return Redirect::to('/');
        }

        return $next($request);
    }
}
