<?php

namespace evApps\Installer\app\Http\Controllers;

use evApps\Installer\app\Http\Requests\DatabaseRequest;
use evApps\Installer\app\Http\Utilities\Installer;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Redirect;

/**
 * Class DatabaseController
 *
 * @package evApps\Installer\app\Http\Controllers
 */
class DatabaseController extends Controller
{

    /**
     * @return array|\Illuminate\Contracts\View\Factory|\Illuminate\View\View|mixed
     */
    public function showStepForm()
    {
        return view('installer::steps.database');
    }

    /**
     * @param \evApps\Installer\app\Http\Requests\DatabaseRequest $request
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function saveStepData(DatabaseRequest $request)
    {
        try {
            Installer::checkDbConnection(
                $request->input('dbConnection'),
                $request->input('dbHost'),
                $request->input('dbPort'),
                $request->input('dbName'),
                $request->input('dbUserName'),
                $request->input('dbPassword')
            );
        } catch (\Exception $exception) {
            return Redirect::back()
                ->withErrors($exception->getMessage())
                ->withInput();
        }

        Installer::saveStepData(Installer::DATABASE_STEP, [
            'dbConnection' => $request->input('dbConnection'),
            'dbHost' => $request->input('dbHost'),
            'dbPort' => $request->input('dbPort'),
            'dbName' => $request->input('dbName'),
            'dbUserName' => $request->input('dbUserName'),
            'dbPassword' => $request->input('dbPassword'),
        ]);

        Installer::completeStep(Installer::DATABASE_STEP);

        return Redirect::route('evapps.installer.' . Installer::FIRST_OBJECT_STEP . '-show-step-form');
    }
}
