<?php

namespace evApps\Installer;

use evApps\Installer\app\Http\Middleware\IsAlreadyInstalled;
use evApps\Installer\app\Http\Middleware\IsNotAlreadyInstalled;
use evApps\Installer\app\Http\Middleware\Locale;
use evApps\Installer\app\Http\Middleware\StepCompleted;
use evApps\Installer\app\Http\Utilities\Installer;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;

/**
 * Class InstallerServiceProvider
 *
 * @package evApps\Installer
 */
class InstallerServiceProvider extends ServiceProvider
{

    /**
     * Perform post-registration booting of services.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__ . '/config' => config_path()
        ], 'config');

        $this->loadRoutesFrom(__DIR__ . '/routes/evapps/installer.php');

        $this->loadViewsFrom(
            __DIR__ . '/resources/views',
            'installer'
        );

        $this->loadTranslationsFrom(
            __DIR__ . '/resources/lang',
            'installer'
        );

        $this->registerMiddlewares();

        $this->publishes([
            __DIR__ . '/resources/assets' => public_path('vendor/evapps/installer'),
        ], 'public');

        Installer::checkEnvFile();
    }

    /**
     * Register bindings in the container.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/config/evapps/installer.php',
            'evapps.installer'
        );
    }

    public function registerMiddlewares()
    {
        Route::aliasMiddleware('installer.locale', Locale::class);
        Route::aliasMiddleware('installer.stepCompleted', StepCompleted::class);
        Route::aliasMiddleware('installer.isNotAlreadyInstalled', IsNotAlreadyInstalled::class);
        Route::aliasMiddleware('installer.isAlreadyInstalled', IsAlreadyInstalled::class);
    }
}
