<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    if (Auth::user()) {
        return redirect()->route('home');
    } else {
        return redirect()->route('login');
    }
});

Route::get('setlocale/{locale}', function ($locale) {
    if (in_array($locale, \Config::get('app.locales'))) {
        return back()->withCookie(cookie()->forever('locale', $locale));
    }
    return redirect()->back();
});

Route::get('setobject/{object}', function ($object) {
    if (in_array($object, \App\Models\Building::query()->pluck('id')->toArray())) {
        return back()->withCookie(cookie()->forever('object', (int) $object));
    }
    return redirect()->back();
})->name('setobject');

Route::group(
    [
        'middleware' => 'web',
        'prefix'     => config('backpack.base.route_prefix'),
    ],
    function () {
        // if not otherwise configured, setup the auth routes
        if (!config('backpack.base.setup_auth_routes')) {
            Route::auth();
            Route::get('logout', 'Auth\LoginController@logout');
        }

        if (!config('backpack.base.setup_dashboard_routes')) {
            Route::get('dashboard', 'AdminController@dashboard')->name('home');
            Route::get('/', 'AdminController@redirect');
        }
    }
);