<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Mock API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register mock API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "mock" middleware group. Enjoy building your mock API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('/locale', 'LocaleController@getLocale');
Route::put('/locale', 'LocaleController@setLocale');

Route::post('/login', 'LoginController@login');
Route::post('/logout', 'LoginController@logout');

Route::get('/messages/count', 'MessagesCounterController@getTotalUnreadCount');

Route::put('/adverts/{id}', 'AdvertController@markUserAdvertAsRead');
Route::get('/adverts', 'AdvertController@getUserAdverts');
Route::get('/advertsboard', 'AdvertController@getUserAdvertsBoard');

Route::put('/notifications/{id}', 'NotificationController@markUserNotificationAsRead');
Route::get('/notifications', 'NotificationController@getUserNotifications');

Route::post('/recall', 'ReCallController@recall');

Route::post('/quizzes/{id}/answers', 'QuizController@setQuizAnswers');
Route::get('/quizzes/{id}', 'QuizController@getQuizResults');
Route::put('/quizzes/{id}', 'QuizController@markQuizAsRead');
Route::get('/quizzes', 'QuizController@getUserQuizzes');

Route::get('/claims/{id}', 'ClaimController@getClaim');
Route::put('/claims/{id}', 'ClaimController@updateClaim');
Route::get('/claims', 'ClaimController@getUserClaims');
Route::post('/claims', 'ClaimController@createClaim');
Route::get('/claimtypes', 'ClaimController@getUserClaimTypes');

Route::get('/cameras', 'CameraController@getUserCameras');

Route::post('/pushtoken', 'PushTokenController@setToken');
