<?php

use Illuminate\Http\Request;
use App\Models\User;

/*
|--------------------------------------------------------------------------
| API Test Routes
|--------------------------------------------------------------------------
|
| Here is 'service' API routes. Using for testing purpose only.
| Should be disabled on production
|
*/

Route::namespace('ApiTest')->group(function () {

    Route::middleware(['auth:api', 'scope:' . urlencode('полный доступ')])
      ->get('/user', function (Request $request) {
          return $request->user();
      });

    Route::middleware('auth:api')
        ->get('/profile', function (Request $request) {
            return $request->user();
        });

    Route::middleware(['auth:api', 'scope:' . urlencode('полный доступ')])
      ->get('/user/token', function (Request $request) {
          return $request->user()->token()->id;
      });

    Route::middleware(['auth:api', 'scope:' . urlencode('полный доступ')])
      ->get('/user/devices', function (Request $request) {
          return $request->user()->devices()->get();
      });

    Route::post('/sendpush', 'ApiTestController@sendpush');

    Route::get('/apartments/{apartment}', function(\App\Models\Apartment $apartment){
        return $apartment->users()->withCount('tokens')->pluck('tokens_count')->sum();
    });
    Route::get('/sql', function(Request $request){
        $res = User::where('users.id', [])
            ->select('devices.push_token')
            ->join('oauth_access_tokens', 'oauth_access_tokens.user_id', '=', 'users.id')
            ->join('devices', 'devices.id', '=', 'oauth_access_tokens.id')
            ->where('devices.push_token', '!=', '')
            ->get();

        return $res;
    });

    Route::get('/optional-token', 'ApiTestController@optionalToken');

});


Route::namespace('Api\Auth')->group(function () {
    Route::post('/login', 'LoginController@login');
});


