@extends('backpack::layout')
@section('header')
    <section class="content-header">
        <h1>
            {{ trans('styles.set') }}
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{ url(config('backpack.base.route_prefix'),'dashboard') }}">{{ trans('backpack::crud.admin') }}</a></li>
            <li><a href="{{ url($crud->route) }}" class="text-capitalize">{{ $crud->entity_name_plural }}</a></li>
            <li class="active">{{ trans('backpack::crud.edit') }}</li>
        </ol>
    </section>
@endsection

@section('content')
    <div class="row edit-form" id="edit-quiz">
        <div class="col-md-12">
            <!-- Default box -->
            @include('crud::inc.grouped_errors')

            <form method="post"
                  action="{{ url($crud->route) }}"
                  @if ($crud->hasUploadFields('update', $entry->getKey()))
                  enctype="multipart/form-data"
                  @endif
            >
                {!! csrf_field() !!}
                {!! method_field('PUT') !!}
            <div class="box">
                <div class="box-header with-border">
                    <div class="box-body row">
                        <!-- load the view from the application if it exists, otherwise load the one in the package -->
                        @include('vendor.backpack.crud.style.form_content', [ 'fields' => $crud->getFields('create'), 'action' => 'create' ])

                    </div><!-- /.box-body -->

                    @foreach($styles as $style)
                        <div class="col-xs-4">
                            <div class="type">
                                <div class="title {{ ($entry->style_id == $style->id)? 'active': '' }}"  data-id="{{ $style->id }}">
                                    <span class="icon {{ $style->icon }}" role="presentation" aria-hidden="true"></span>
                                    <span>{{ trans('styles.types.'.$style->type.'.title') }}</span>
                                </div>
                                <div class="desc">
                                    {{ trans('styles.types.'.$style->type.'.desc') }}
                                </div>
                            </div>
                        </div>
                    @endforeach

                    <div id="saveActions" class="form-group">
                        <div class="btn-group">
                            <button type="submit" class="btn btn-success">
                                <span class="fa fa-save" role="presentation" aria-hidden="true"></span> &nbsp;
                                <span>{{ trans('styles.buttons.save') }}</span>
                            </button>
                        </div>
                    </div>


            </div><!-- /.box -->
            </div>
            </form>
        </div>
    </div>
@endsection