@extends('backpack::layout')

@push('after_scripts')
    <script>
        jQuery('document').ready(function() {
            // Подготовка переменных, с которыми будет осуществляться работа
            var permissions = JSON.parse('{!!$permissions!!}');

            var input_permissions = $('label input[name="permissions[]"]');

            // Получить идентификатор полного доступа
            var full_access_id = getFullAccess(permissions);
            var full_access_object = $('label input[name="permissions[]"][value="'+full_access_id+'"]');

            // Заблокировать все права при загрузке, если выбран "полный доступ"
            if (full_access_object.prop('checked') === true) {
                bootBlockAll(input_permissions, full_access_id, true, true);
            }

            // Обработка клика по определенному праву
            input_permissions.click(function() {
                // Идентификатор текущего права
                var permission_id = $(this).val();

                if ($(this).prop('checked') === true) {

                    if (permissions[permission_id].hasOwnProperty('full_access') && permissions[permission_id].full_access === true) {
                        // Если выбрано правило "полный доступ", то блокируем все остальные правила
                        blockAll(input_permissions, permission_id, true);
                        return true;
                    }

                    var need_to_check = getPermissionsByWeight(permissions, permission_id, false);
                    checkPermissions(input_permissions, need_to_check, true);
                    correctRoles(input_roles, roles);
                } else {

                    if (permissions[permission_id].hasOwnProperty('full_access') && permissions[permission_id].full_access === true) {
                        // Если выбрано правило "полный доступ", то разброкируем другие правила
                        blockAll(input_permissions, permission_id, false);
                    }

                    var need_to_check = getPermissionsByWeight(permissions, permission_id, false, false);
                    checkPermissions(input_permissions, need_to_check, false);
                    correctRoles(input_roles, roles);
                }
            });

            // Установка или снятие галочек для прав
            function checkPermissions(input_permissions, permissions_keys, checked = true)
            {
                input_permissions.each(function() {
                    var id = $(this).val();
                    if (permissions_keys.includes(Number(id))) {
                        $(this).prop('checked', checked);
                    }
                });
            }

            // Получить список прав по весу меньших, чем текущее
            function getPermissionsByWeight(permissions, id, current = false, weight = true)
            {
                var permissions_keys = Object.keys(permissions);
                var weightPermissions = [];

                permissions_keys.forEach(function (key) {
                    if (weight) {
                        if (permissions[key].group === permissions[id].group && permissions[key].weight < permissions[id].weight) {
                            weightPermissions.push(Number(key));
                        }
                    } else {
                        if (permissions[key].group === permissions[id].group && permissions[key].weight > permissions[id].weight) {
                            weightPermissions.push(Number(key));
                        }
                    }
                });

                // Добавить текущий элемент, если требуется
                if (current) {
                    weightPermissions.push(id);
                }

                // Отсортировать по возрастанию
                weightPermissions = weightPermissions.sort(function(a, b) {
                    return a - b;
                });

                return weightPermissions;
            }

            // Получить идентификатор полного доступа
            function getFullAccess(permissions)
            {
                var permissions_keys = Object.keys(permissions);
                var full_access_id = null;

                // Найти идентификатор полного доступа
                permissions_keys.forEach(function (permission_key) {
                    console.log(permissions[permission_key].hasOwnProperty('full_access'));
                    if (permissions[permission_key].hasOwnProperty('full_access') && permissions[permission_key].full_access === true) {
                        full_access_id = permission_key;
                    }
                });

                return full_access_id;
            }

            // Блокировка или снятие блокировки с остальных галочек
            function blockAll(input_permissions, full_access_id, block = true, full_access_check = false)
            {
                input_permissions.each(function() {
                    if ($(this).val() !== full_access_id) {
                        $(this).prop('checked', false).prop('disabled', block);
                    } else {
                        if (full_access_check) {
                            $(this).prop('checked', true).prop('disabled', !block);
                        }
                    }
                });
            }

            // Заблокировать все права при загрузке, если выбран полный доступ
            function bootBlockAll(input_permissions, full_access_id, block = true, full_access_check = false)
            {
                if (full_access_id) {
                    blockAll(input_permissions, full_access_id, block, full_access_check);
                }
            }
        });
    </script>
@endpush

@section('header')
	<section class="content-header">
	  <h1>
	    {{ trans('backpack::crud.add') }} <span>{{ $crud->entity_name }}</span>
	  </h1>
	  <ol class="breadcrumb">
	    <li><a href="{{ url(config('backpack.base.route_prefix'), 'dashboard') }}">{{ trans('backpack::crud.admin') }}</a></li>
	    <li><a href="{{ url($crud->route) }}" class="text-capitalize">{{ $crud->entity_name_plural }}</a></li>
	    <li class="active">{{ trans('backpack::crud.add') }}</li>
	  </ol>
	</section>
@endsection

@section('content')
<div class="row">
	<div class="col-md-8 col-md-offset-2">
		<!-- Default box -->
		@if ($crud->hasAccess('list'))
			<a href="{{ url($crud->route) }}"><i class="fa fa-angle-double-left"></i> {{ trans('backpack::crud.back_to_all') }} <span>{{ $crud->entity_name_plural }}</span></a><br><br>
		@endif

		@include('crud::inc.grouped_errors')

        <form method="post"
              action="{{ url($crud->route) }}"
              @if ($crud->hasUploadFields('create'))
              enctype="multipart/form-data"
                @endif
        >
            {!! csrf_field() !!}
		  <div class="box">

		    <div class="box-header with-border">
		      <h3 class="box-title">{{ trans('backpack::crud.add_a_new') }} {{ $crud->entity_name }}</h3>
		    </div>
		    <div class="box-body row">
		      <!-- load the view from the application if it exists, otherwise load the one in the package -->
		      @if(view()->exists('vendor.backpack.crud.form_content'))
		      	@include('vendor.backpack.crud.form_content', [ 'fields' => $crud->getFields('create'), 'action' => 'create' ])
		      @else
		      	@include('crud::form_content', [ 'fields' => $crud->getFields('create'), 'action' => 'create' ])
		      @endif
		    </div><!-- /.box-body -->
		    <div class="box-footer">

                @include('crud::inc.form_save_buttons_extended')

		    </div><!-- /.box-footer-->

		  </div><!-- /.box -->
        </form>
	</div>
</div>

@endsection