@if ($crud->model->translationEnabled())
    <input type="hidden" name="locale"
           value={{ $crud->request->input('locale')?$crud->request->input('locale'):App::getLocale() }}>
@endif

@include('vendor.backpack.components.destinations.component', ['fields' => $fields])

@include('vendor.backpack.crud.quiz.preview_fields', ['fields' => $fields])

{{-- Define blade stacks so css and js can be pushed from the fields to these sections. --}}

@section('after_styles')
    <link rel="stylesheet" href="{{ asset('vendor/backpack/crud/css/crud.css') }}">
    <link rel="stylesheet" href="{{ asset('vendor/backpack/crud/css/form.css') }}">
    <link rel="stylesheet" href="{{ asset('vendor/backpack/crud/css/'.$action.'.css') }}">
    <link rel="stylesheet" href="{{ asset('vendor/backpack/destinations/component.css') }}">


    <!-- CRUD FORM CONTENT - crud_fields_styles stack -->
    @stack('crud_fields_styles')
@endsection

@section('after_scripts')
    <script src="{{ asset('vendor/backpack/crud/js/crud.js') }}"></script>
    <script src="{{ asset('vendor/backpack/crud/js/form.js') }}"></script>
    <script src="{{ asset('vendor/backpack/crud/js/'.$action.'.js') }}"></script>
    <script src="{{ asset('vendor/backpack/destinations/component.js') }}"></script>


    <!-- CRUD FORM CONTENT - crud_fields_scripts stack -->
    @stack('crud_fields_scripts')

    <script>
        jQuery('document').ready(function ($) {

            // Save button has multiple actions: save and exit, save and edit, save and new
            var saveActions = $('#saveActions'),
                crudForm = saveActions.parents('form'),
                saveActionField = $('[name="save_action"]');

            saveActions.on('click', 'button', function (e) {
                e.preventDefault();
                var saveAction = $(this).data('value');
                saveActionField.val(saveAction);
                crudForm.submit();
            });

            // Ctrl+S and Cmd+S trigger Save button click
            $(document).keydown(function (e) {
                if ((e.which == '115' || e.which == '83' ) && (e.ctrlKey || e.metaKey)) {
                    e.preventDefault();
                    // alert("Ctrl-s pressed");
                    $("button[type=submit]").trigger('click');
                    return false;
                }
                return true;
            });

            // Place the focus on the first element in the form
            @if( $crud->autoFocusOnFirstField )
                    @php
                        $focusField = array_first($fields, function($field) {
                            return isset($field['auto_focus']) && $field['auto_focus'] == TRUE;
                        });
                    @endphp

                    @if ($focusField)
                window.focusField = $('[name="{{ $focusField['name'] }}"]').eq(0),
                    @else
            var focusField = $('form').find('input, textarea, select').not('[type="hidden"]').eq(0),
                    @endif

                    fieldOffset = focusField.offset().top,
                scrollTolerance = $(window).height() / 2;

            focusField.trigger('focus');

            if (fieldOffset > scrollTolerance) {
                $('html, body').animate({scrollTop: (fieldOffset - 30)});
            }
            @endif

            // Add inline errors to the DOM
            @if ($crud->inlineErrorsEnabled() && $errors->any())

                window.errors = {!! json_encode($errors->messages()) !!};
            // console.error(window.errors);

            $.each(errors, function (property, messages) {

                var field = $('[name="' + property + '[]"]').length ?
                    $('[name="' + property + '[]"]') :
                    $('[name="' + property + '"]'),
                    container = field.parents('.form-group');

                container.addClass('has-error');

                $.each(messages, function (key, msg) {
                    // highlight the input that errored
                    var row = $('<div class="help-block">' + msg + '</div>');
                    row.appendTo(container);

                    // highlight its parent tab
                            @if ($crud->tabsEnabled())
                    var tab_id = $(container).parent().attr('id');
                    $("#form_tabs [aria-controls=" + tab_id + "]").addClass('text-red');
                    @endif
                });
            });

            @endif

            $('#templates-picker').on("templatePickerHide", function (event, data) {
                console.log(data);
                $('#title').val(data.title);
                $('#question').val(data.question);

                if(data.answers){
                    var $answers = [];
                    if($('.array-container table tbody tr').length){
                        $('.array-container table tbody tr button').click();
                    }
                    $.each(data.answers, function(){
                        $answers.push({text: $(this)[0]['text']});
                        $('.array-container .array-controls button').click();
                        $('.array-container table tbody tr:last input').val($(this)[0]['text']).change();
                    });
                }

                if(data.multiple == 1){
                    $('#multiple').prop('checked',1);
                } else {
                    $('#multiple').prop('checked',0);
                }

                if(data.free_answer == 1){
                    $('#free_answer').prop('checked',1);
                } else {
                    $('#free_answer').prop('checked',0);
                }
            });

        });
    </script>
@endsection
