<style>
    .quiz-progress {
        height: 25px;
        background-color: #dedede;
        border: 1px solid lightgrey;
    }

    .quiz-progress-wrapper {
        margin-bottom: 10px;
    }

    .empty {
        padding: 10px 5px;
        border: 1px solid grey;
        background-color: #dedede;
    }

    .free-answer-items-holder {
        margin-bottom: 10px;
        line-height: 25px;
    }
    .free-answer-items-holder > span {
        border: 1px solid lightgrey;
        border-radius: 10px;
        background-color: #dedede;
        padding: 0 7px;
        white-space: nowrap;
    }
</style>
<div class="print-wrapper">
    <h1>
        {{ $title }}
    </h1>
    @if ($empty)
        <div><p class="empty bg-danger">{{ trans('quizzes.empty') }}</p></div>
    @endif
<!-- THE ACTUAL CONTENT -->
    <div>
        <p>{{ trans('quizzes.crud_fields.status') }}: {{ $entry->status }}</p>

    </div>
    <div>
        <p>{{ trans('quizzes.crud_fields.question') }}: {{ $entry->question }}</p>
    </div>
    <div class="col-xs-12">
        <h4>{{ trans('quizzes.crud_fields.variants') }}:</h4>
    </div>
    @foreach ($entry->answers as $k => $answer)
        <p class="answer-text">
            {{ $answer->text }}
            @if(!$empty)
                ({{ $answer->percent }}%)
            @endif
        </p>
        @if(!$empty)
            <div class="quiz-progress-wrapper">
                <div  class="bg-info quiz-progress" style="width:{{ $answer->percent }}%"></div>
            </div>
        @endif
    @endforeach

    @if (!$empty && $free_answers_percent)
        <p class="answer-text">{{ trans('quizzes.another') }} ({{ $free_answers_percent }}%)</p>
        <div class="quiz-progress-wrapper">
            <div class="bg-info quiz-progress" style="width:{{ $free_answers_percent }}%"></div>
        </div>
        <div class="col-sm-12 free-answer-items-holder">
            @foreach($free_answers as $answer => $number)
                <span>{{ $answer }}</span>
            @endforeach
        </div>
    @endif
</div>

<script>
    window.print();

    window.onafterprint = function() {
        window.location.href = '{{ $backUrl }}';
    };
</script>