@extends('backpack::layout')

@section('header')
    <section class="content-header">
        <h1>
            {{ trans('backpack::crud.add') }} <span>{{ $crud->entity_name }}</span>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{ url(config('backpack.base.route_prefix'), 'dashboard') }}">{{ trans('backpack::crud.admin') }}</a></li>
            <li><a href="{{ url($crud->route) }}" class="text-capitalize">{{ $crud->entity_name_plural }}</a></li>
            <li class="active">{{ trans('backpack::crud.add') }}</li>
        </ol>
    </section>
@endsection

@section('content')
    <div class="row create-form" id="create-advert">
        <div class="col-md-8 col-md-offset-2">
            <!-- Default box -->
            @if ($crud->hasAccess('list'))
                <a href="{{ url($crud->route) }}"><i class="fa fa-angle-double-left"></i> {{ trans('backpack::crud.back_to_all') }} <span class="text-capitalize">{{ $crud->entity_name_plural }}</span></a><br><br>
            @endif

            @include('crud::inc.grouped_errors')

            <form method="post"
                  action="{{ url($crud->route) }}"
                  @if ($crud->hasUploadFields('create'))
                  enctype="multipart/form-data"
                    @endif
            >
                {!! csrf_field() !!}
            <div class="box">

                <div class="box-header with-border">
                    <h3 class="box-title">{{ trans('notice.actions.add') }}</h3>
                </div>
                <div class="box-body row">
                    <!-- load the view from the application if it exists, otherwise load the one in the package -->
                    @if(view()->exists('vendor.backpack.crud.notice.form_content'))
                        @include('vendor.backpack.crud.notice.form_content', [ 'fields' => $crud->getFields('create'), 'action' => 'create' ])
                    @else
                        @include('crud::form_content', [ 'fields' => $crud->getFields('create'), 'action' => 'create' ])
                    @endif
                </div><!-- /.box-body -->
                <div class="box-footer">

                    @include('vendor.backpack.crud.notice.form_create_buttons')

                </div><!-- /.box-footer-->

            </div><!-- /.box -->
            </form>
        </div>
    </div>
    @include('vendor.backpack.components.templates-picker.component')
@endsection