@extends('crud::list')

@section('content')

    <!-- Default box -->
    <div class="row-flex row" id="reviews-groups">
        <div class="col-width-240 col-lg-2">
            <div class="box">
                @yield('tree_menu')
            </div>
        </div>
        <!-- THE ACTUAL CONTENT -->
        <div class="col-auto col-md-12 col-lg-10">
            <div class="box">
                <div class="box-header hidden-print {{ $crud->hasAccess('create')?'with-border':'' }}">

                    <h3 class="box-title pull-left">
                        @if (!empty($selected['apartment']))
                            {{ trans('reviews.crud_fields.apartment') }} {{$selected['apartment']}}
                        @else
                            {{ trans('backpack::crud.all') }} {{ $crud->entity_name_plural }}
                        @endif
                    </h3>
                    <a class="btn btn-primary pull-right" href="{{ url($crud->route) }}">{{ trans('reviews.buttons.list') }}</a>

                </div>

                <div class="box-body table-responsive">

                    <table id="crudTable" class="table table-striped table-hover display responsive nowrap"
                           cellspacing="0">
                        <thead>
                        <tr>
                            {{-- Table columns --}}
                            @foreach ($crud->columns as $column)
                                <th
                                        data-orderable="{{ var_export($column['orderable'], true) }}"
                                        data-priority="{{ $column['priority'] }}"
                                >
                                    {{ $column['label'] }}
                                </th>
                            @endforeach

                            @if ( $crud->buttons->where('stack', 'line')->count() )
                                <th data-orderable="false"
                                    data-priority="{{ $crud->getActionsColumnPriority() }}">{{ trans('backpack::crud.actions') }}</th>
                            @endif
                        </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                        <tr>
                            {{-- Table columns --}}
                            @foreach ($crud->columns as $column)
                                <th>{{ $column['label'] }}</th>
                            @endforeach

                            @if ( $crud->buttons->where('stack', 'line')->count() )
                                <th>{{ trans('backpack::crud.actions') }}</th>
                            @endif
                        </tr>
                        </tfoot>
                    </table>

                </div><!-- /.box-body -->

                @include('crud::inc.button_stack', ['stack' => 'bottom'])

            </div><!-- /.box -->
        </div>

    </div>

@endsection

@push('after_scripts')
    <script src="{{ asset('vendor/backpack/house-tree-menu/component.js') }}"></script>
@endpush
