<!-- text input -->
<div @include('crud::inc.field_wrapper_attributes') >
    <label>{!! $field['label'] !!}</label>
    @include('crud::inc.field_translatable_icon')

    @if(isset($field['prefix']) || isset($field['suffix'])) <div class="input-group"> @endif
        @if(isset($field['prefix'])) <div class="input-group-addon">{!! $field['prefix'] !!}</div> @endif
        <input
            type="text"
            id ="tags"
            name="{{ $field['name'] }}"
            value="{{ old($field['name']) ? old($field['name']) : (isset($field['value']) ? $field['value'] : (isset($field['default']) ? $field['default'] : '' )) }}"
            @include('crud::inc.field_attributes')
        >
        @if(isset($field['suffix'])) <div class="input-group-addon">{!! $field['suffix'] !!}</div> @endif
    @if(isset($field['prefix']) || isset($field['suffix'])) </div> @endif

    {{-- HINT --}}
    @if (isset($field['hint']))
        <p class="help-block">{!! $field['hint'] !!}</p>
    @endif
</div>


{{-- FIELD EXTRA CSS  --}}
{{-- push things in the after_styles section --}}

@push('crud_fields_styles')
    <link rel="stylesheet" href="{{ asset('vendor/backpack/bootstrap-tagsinput/bootstrap-tagsinput.css') }}">
    <link rel="stylesheet" href="{{ asset('vendor/backpack/bootstrap-tagsinput/bootstrap-tagsinput-typeahead.css') }}">

@endpush


{{-- FIELD EXTRA JS --}}
{{-- push things in the after_scripts section --}}

@push('crud_fields_scripts')
    <script src="{{ asset('vendor/backpack/bootstrap-tagsinput/bootstrap-tagsinput.js') }}"></script>
    <script src="{{ asset('vendor/backpack/bootstrap-tagsinput/typeahead.jquery.js') }}"></script>
    <script src="{{ asset('vendor/backpack/bootstrap-tagsinput/typeahead.bundle.min.js') }}"></script>
    <script src="{{ asset('vendor/backpack/bootstrap-tagsinput/bloodhound.js') }}"></script>
    <script>
        var bloodHoundObj = new Bloodhound({
            datumTokenizer: Bloodhound.tokenizers.whitespace,
            queryTokenizer: Bloodhound.tokenizers.whitespace,
            // url points to a json file that contains an array of country names, see
            // https://github.com/twitter/typeahead.js/blob/gh-pages/data/countries.json
            local: <?= ($field['variants'])?:[]?>
        });

        $('#tags').tagsinput({
            typeaheadjs: {
                source:  bloodHoundObj.ttAdapter(),
            },
            freeInput: true
        });

        $('.twitter-typeahead input').on('change', function(){
            var curr = '';
            $('.tag').each(function(){
                if($(this).index()) {
                    curr += ',';
                }
                curr += $(this).text();
            });
            if($(this).val()){
                if(curr.length){
                    curr += ',';
                }

                curr += $(this).val();
            }
            $('#tags').val(curr);
        })

    </script>
@endpush


{{-- Note: you can use @if ($crud->checkIfFieldIsFirstOfItsType($field, $fields)) to only load some CSS/JS once, even though there are multiple instances of it --}}