@extends('backpack::layout')

@section('content-header')
    <section class="content-header">
        <h1>
            {{ trans('backpack::crud.preview') }} <span class="text-lowercase">{{ $crud->entity_name }}</span>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{{ url(config('backpack.base.route_prefix'), 'dashboard') }}">{{ trans('backpack::crud.admin') }}</a></li>
            <li><a href="{{ url($crud->route) }}" class="text-capitalize">{{ $crud->entity_name_plural }}</a></li>
            <li class="active">{{ trans('backpack::crud.preview') }}</li>
        </ol>
    </section>
@endsection

@section('content')
    @if ($crud->hasAccess('list'))
        <a href="{{ url($crud->route) }}"><i class="fa fa-angle-double-left"></i> {{ trans('backpack::crud.back_to_all') }} <span class="text-lowercase">{{ trans('apartments.apartment_plural_2')}}</span></a><br><br>
    @endif

    <!-- Default box -->
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">
                {{ trans('backpack::crud.preview') }}
                <span class="text-lowercase">{{ trans('apartments.apartment_singular_3') }}</span>
            </h3>
        </div>
        <div class="box-body">
            <table class="table table-striped table-bordered">
                <tbody>
                @foreach ($crud->columns as $column)
                    <tr>
                        <td>
                            <strong>{{ $column['label'] }}</strong>
                        </td>
                        <td>
                        @if (!isset($column['type']))
                            @include('crud::columns.text')
                        @else
                            @if(view()->exists('vendor.backpack.crud.columns.'.$column['type']))
                                @include('vendor.backpack.crud.columns.'.$column['type'])
                            @else
                                @if(view()->exists('crud::columns.'.$column['type']))
                                    @include('crud::columns.'.$column['type'])
                                @else
                                    @include('crud::columns.text')
                                @endif
                            @endif
                        @endif
                        </td>
                    </tr>
                @endforeach
                @if ($crud->buttons->where('stack', 'line')->count())
                    <tr>
                        <td><strong>{{ trans('backpack::crud.actions') }}</td>
                        <td>
                            @include('crud::inc.button_stack', ['stack' => 'line'])
                        </td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div><!-- /.box-body -->
    </div><!-- /.box -->

@endsection


@section('after_styles')
    <link rel="stylesheet" href="{{ asset('vendor/backpack/crud/css/crud.css') }}">
    <link rel="stylesheet" href="{{ asset('vendor/backpack/crud/css/show.css') }}">
@endsection

@section('after_scripts')
    <script src="{{ asset('vendor/backpack/crud/js/crud.js') }}"></script>
    <script src="{{ asset('vendor/backpack/crud/js/show.js') }}"></script>

    @if ($crud->buttons->where('stack', 'line')->count())
    <script>
        function register_reset_activations_button_action() {
            $("[data-button-type=reset_activation]").unbind('click');
            // CRUD Action
            // ask for confirmation before deleting an item
            $("[data-button-type=reset_activation]").click(function(e) {
                e.preventDefault();
                var reset_activations_button = $(this);
                var action_url = $(this).attr('href');
                var activations_used_container = reset_activations_button.closest('table').find('.activations-used-value');
                var sip_numbers_used_container = reset_activations_button.closest('table').find('.sip-numbers-used');

                console.log(activations_used_container.text());

                if (confirm("{{ trans('apartments.reset_confirm') }}") == true) {
                    $.ajax({
                        url: action_url,
                        type: 'GET',
                        success: function(result) {
                            if (activations_used_container.text() == 0) {
                                new PNotify({
                                    title: "{{ trans('apartments.reset_confirmation_no_reset_title') }}",
                                    text: "{{ trans('apartments.reset_confirmation_no_reset_message') }}",
                                    type: "info"
                                });
                                return false;
                            } else {
                                // Show an alert with the result
                                new PNotify({
                                    title: "{{ trans('apartments.reset_confirmation_title') }}",
                                    text: "{{ trans('apartments.reset_confirmation_message') }}",
                                    type: "success"
                                });
                            }
                            // delete the row from the table
                            activations_used_container.html(result.activations_used);
                            sip_numbers_used_container.find('span').each(function () {
                                $(this).removeClass('sip-is-used');
                            });
                        },
                        error: function(result) {
                            // Show an alert with the result
                            if (result.status === 421) {
                                new PNotify({
                                    text: "{{ trans('response_error.421') }}",
                                    type: "error",
                                    icon: false
                                });
                            } else {
                                new PNotify({
                                    title: "{{ trans('apartments.reset_confirmation_not_title') }}",
                                    text: "{{ trans('apartments.reset_confirmation_not_message') }}",
                                    type: "warning"
                                });
                            }
                        }
                    });
                } else {
                    new PNotify({
                        title: "{{ trans('apartments.reset_confirmation_not_reset_title') }}",
                        text: "{{ trans('apartments.reset_confirmation_not_reset_message') }}",
                        type: "info"
                    });
                }
            });
        }

        register_reset_activations_button_action();
    </script>
    @endif
@endsection
