@extends('backpack::layout')

@section('header')
    <section class="content-header">
        <h1>
            {{ $title }}
        </h1>
        <ol class="breadcrumb">
            <li>
                <a href="{{ url(config('backpack.base.route_prefix'), 'dashboard') }}">{{ trans('backpack::crud.admin') }}</a>
            </li>
            <li><a href="{{ url($crud->route) }}" class="text-capitalize">{{ $crud->entity_name_plural }}</a></li>
            <li class="active">{{ trans('adverts.results') }}</li>
        </ol>

    </section>
@endsection

@section('content')
<div class="row">
    {{--<div class="col-md-12">{{ __('adverts.to_apartments') }}: {{ $destinations }} </div>--}}
    <div class="col-md-12">{{ __('adverts.sent') }}: {{ $count_destination }} </div>
    <div class="col-md-12">{{ __('adverts.viewers') }}: {{ $count_viewed }} </div>
    <div class="col-md-12">{{ __('adverts.not_viewers') }}: {{ $count_destination - $count_viewed }} </div>
    <div class="col-xs-12">
        <br>
        <a href="/admin/announcement/" class="btn btn-default">
            <span class="fa fa-angle-left" role="presentation" aria-hidden="true"></span> &nbsp;
            <span>{{ trans('adverts.buttons.back') }}</span>
        </a>
    </div>
</div>

@if(!empty($apartments))
    <h3>{{ trans('apartments.do_not_read_advert') }}</h3>
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-body overflow-hidden">
                    <table id="crudTable" class="table table-striped table-hover display responsive nowrap"
                           cellspacing="0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('apartments.crud_fields.number') }}</th>
                                <th>{{ trans('apartments.crud_fields.entrance') }}</th>
                                <th>{{ trans('apartments.crud_fields.floor') }}</th>
{{--                                <th>{{ trans('apartments.crud_fields.activation_code') }}</th>--}}
{{--                                <th>{{ trans('apartments.crud_fields.activation_limit') }}</th>--}}
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($apartments as $key => $apartment)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $apartment->number }}</td>
                                    <td>{{ $apartment->entrance }}</td>
                                    <td>{{ $apartment->floor }}</td>
                                    {{--<td>{{ $apartment->activation_code }}</td>--}}
                                    {{--<td>{{ $apartment->activation_limit }}</td>--}}
                                </tr>
                            @endforeach
                        </tbody>
                </div>
            </div>
        </div>
    </div>
@endif

@endsection

@section('after_styles')


    <!-- CRUD FORM CONTENT - crud_fields_styles stack -->
    @stack('crud_fields_styles')
@endsection




