@extends('crud::list')

@push('after_scripts')
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            function register_hide_button_action() {
                $("[data-button-type=hide]").unbind('click');
                // CRUD Delete
                // ask for confirmation before deleting an item
                $("[data-button-type=hide]").click(function(e) {
                    e.preventDefault;
                    $acrualToTextContainer = $(this).closest('tr').find('.actual-date-to');
                    id = $(this).attr('data-id');
                    if (confirm('{!! __('adverts.crud.hide_prompt') !!}')) {
                        $.ajax({
                            url: $(this).data('href'),
                            type: 'PUT',
                            success: function (result) {
                                new PNotify({
                                    title: "{{ trans('adverts.action_successful_hide') }}",
                                    text: result.result,
                                    type: "success"
                                });
                                var row = $('#crudTable tr[data-id="'+id+'"]');
                                row.find('.actual-date-to').html(result.time);
                                row.removeClass('font-weight-900').removeClass('font-weight-600');

                                // Hide the modal, if any
                                $('.modal').modal('hide');
                            },
                            error: function (result) {
                                new PNotify({
                                    title: "{{ trans('adverts.advert') }}",
                                    text: "{{ trans('adverts.server_error') }}",
                                    type: "warning"
                                });
                            }
                        });
                    }
                    return false;
                });
            }

            // Выполнить привязку обработчика после обновления страницы
            $('#crudTable').on('draw.dt', function () {
                register_hide_button_action();
            } ).dataTable();

            $('body').on( 'click', function () {
                register_hide_button_action();

                $('.modal-dialog .actual-date-to').html($('#crudTable .actual-date-to').html());
            } );
        });
    </script>
@endpush