<?php
function tree_element($entry, $key, $categories, $crud) {
    if (!isset($entry->tree_element_shown)) {
        // mark the element as shown
        $categories[$key]->tree_element_shown = true;
        $entry->tree_element_shown = true;

        // see if this element has any children
        $children = [];
        foreach ($categories as $key => $subentry) {
            if ($subentry->parent_id == $entry->getKey()) {
                $children[] = $subentry;
            }
        }

        $children = collect($children)->sortBy('lft');

        $isParent = count($children);

        // show the tree element
        echo '<li>';
        echo '<span class="' . ($isParent ? 'treeview' : '') . '">' . $entry->name;
        if ($isParent) {
            echo '<i class="fa fa-caret-down pull-left"></i><i class="fa fa-caret-up pull-left"></i>';
        }
        echo '</span>';

        if (count($entry->items)) {
            echo '<ul class="templates-list">';
            foreach ($entry->items as $template) {
                echo '<li>';
                echo '<input type="hidden" value=\'' . $template->toJson() . '\'>';
                echo '<span>';
                echo $template->theme ?: $template->title;
                echo '</span></li>';
            }
            echo '</ul>';
        }

        // if it does have children, show them
        if ($isParent) {
            echo '<ul class="treeview-menu">';
            foreach ($children as $key => $child) {
                $children[$key] = tree_element($child, $child->getKey(), $categories, $crud);
            }
            echo '</ul>';
        }
        else {

        }
        echo '</li>';
    }

    return $entry;
}

?>
<script>
    window.templatesPickerMessages = {
        category_empty: {
            title: "{{ trans('templates.picker.category_empty') }}",
            type: "info"
        }
    };
</script>
<div class="picker-view-categories-tree">
    <ul class="sidebar-menu categories-tree">
        <?php
        $root_entries = $categories->filter(function ($item) {
            return $item->parent_id == 0;
        });
        foreach ($root_entries as $key => $entry) {
            $root_entries[$key] = tree_element($entry, $key, $categories, $crud);
        }
        ?>
    </ul>
    <div class="form-group">
        <input type="checkbox" id="include-subfolder" checked="checked">&nbsp;&nbsp;
        <label for="include-subfolder">{{trans('templates.picker.include_subfolders')}}</label>
    </div>
</div>
<div class="picker-view-templates"></div>