<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Cache-Control" content="no-cache">

    {{-- Encrypted CSRF token for Laravel, in order for Ajax requests to work --}}
    <meta name="csrf-token" content="{{ csrf_token() }}"/>

    <title>
        {{ isset($title) ? $title.' :: '.config('backpack.base.project_name').' Admin' : config('backpack.base.project_name').' Admin' }}
    </title>

    @yield('before_styles')

    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.5 -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/') }}/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="{{ asset('css/cdn/font-awesome.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/cdn/ionicons.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/bootstrap.expansion.css') }}?v=8">

    <link rel="stylesheet" href="{{ asset('vendor/adminlte/') }}/dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/') }}/dist/css/skins/_all-skins.min.css">

    <link rel="stylesheet" href="{{ asset('vendor/adminlte/') }}/plugins/pace/pace.min.css">
    <link rel="stylesheet" href="{{ asset('vendor/backpack/pnotify/pnotify.custom.min.css') }}">

    <!-- BackPack Base CSS -->
    <link rel="stylesheet" href="{{ asset('vendor/backpack/backpack.base.css') }}?v=16">

    <!-- Custom styles -->
    <link rel="stylesheet" href="{{ asset('vendor/backpack/colorbox/example3/colorbox.css') }}">
    <link rel="stylesheet" href="{{ asset('css/custom.css?v=4') }}">

    @yield('after_styles')
    @stack('after_styles')

<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="{{ asset('/js/cdn/html5shiv.min.js') }}"></script>
    <script src="{{ asset('/js/cdn/respond.min.js') }}"></script>
    <![endif]-->
</head>
<body class="hold-transition {{ config('backpack.base.skin') }} sidebar-mini">
<script type="text/javascript">
    /* Recover sidebar state */
    (function () {
        if (Boolean(sessionStorage.getItem('sidebar-toggle-collapsed'))) {
            var body = document.getElementsByTagName('body')[0];
            body.className = body.className + ' sidebar-collapse';
        }
    })();
</script>
<script>
    AdminLTEOptions = {
        enableBSToppltip: true
    };
</script>
<!-- Site wrapper -->
<div class="wrapper">

    @if(Auth::check())
        <header class="main-header">
            <!-- Header Navbar: style can be found in header.less -->
            @php
                $objects = \App\Models\Building::availableForCurrentUser();
                $current_object_id = config('app.object.id');
                $current_object_address = config('app.object.address');
                $current_object_name = config('app.object.name');
            @endphp
            <nav class="navbar navbar-static-top header-navbar" role="navigation">
                @include('backpack::inc.menu')
            </nav>
        </header>

        <!-- =============================================== -->

    @include('backpack::inc.sidebar')
@endif

<!-- =============================================== -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper{{ Auth::check() ? '' : ' auth m-l-0' }}">
        <!-- Content Header (Page header) -->
    @yield('header')

    <!-- Main content -->
        <section class="content">

            <?php $apartments_saving_count = \App\Helpers\Objects::apartmentsSavingCount();?>

            @if($apartments_saving_count !== 0)
                <div class="callout callout-danger">
                    <a href="/admin/apartment-generation" target="_blank">{{ trans('apartments.generation.stores_link') }}</a> {{ trans('apartments.generation.stores', ['save_number' => $apartments_saving_count]) }}
                </div>
            @endif

            @yield('content')

        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<!--footer class="main-footer{{ Auth::check() ? '' : ' m-l-0' }}">
        @if (config('backpack.base.show_powered_by'))
    <div class="pull-right hidden-xs">
{{ trans('backpack::base.powered_by') }} <a target="_blank" href="http://backpackforlaravel.com?ref=panel_footer_link">Backpack for Laravel</a>
            </div>
        @endif
{{ trans('backpack::base.handcrafted_by') }} <a target="_blank" href="{{ config('backpack.base.developer_link') }}">{{ config('backpack.base.developer_name') }}</a>.
      </footer-->
</div>
<!-- ./wrapper -->


@yield('before_scripts')

<!-- jQuery 2.2.0 -->
<script src="{{ asset('js/cdn/jquery-2.2.0.min.js') }}"></script>
<script>window.jQuery || document.write('<script src="{{ asset('vendor/adminlte') }}/plugins/jQuery/jQuery-2.2.0.min.js"><\/script>')</script>
<!-- Bootstrap 3.3.5 -->
<script src="{{ asset('vendor/adminlte') }}/bootstrap/js/bootstrap.min.js"></script>
<script src="{{ asset('vendor/adminlte') }}/plugins/pace/pace.min.js"></script>
<script src="{{ asset('vendor/adminlte') }}/plugins/slimScroll/jquery.slimscroll.min.js"></script>
<script src="{{ asset('vendor/adminlte') }}/plugins/fastclick/fastclick.js"></script>
<script src="{{ asset('vendor/adminlte') }}/plugins/jQueryUI/jquery-ui.min.js"></script>
<script src="{{ asset('vendor/adminlte') }}/dist/js/app.min.js"></script>

<!-- page script -->
<script type="text/javascript">
    $(document).ready(function () {

        $(window).resize(function () {
            $('.main-sidebar').css('top', $('main-header').css('height'));

        });

        $('#lang_form').change(function () {
            var lang = $(this).val();
            window.location.href = '/setlocale/' + lang;
        });
    });

    $(document).ready(function () {
        $('#object_form').change(function () {
            var obj = $(this).val();
            window.location.href = '/setobject/' + obj;
        });
    });
    /* Store sidebar state */
    $('.sidebar-toggle').click(function (event) {
        event.preventDefault();
        if (!$('body').hasClass('minified')) {
            if (Boolean(sessionStorage.getItem('sidebar-toggle-collapsed'))) {
                $('.logo-lg').css('display', 'inline-block');
                $('.logo-mini').css('display', 'none');
                sessionStorage.setItem('sidebar-toggle-collapsed', '');
            } else {
                $('.logo-lg').css('display', 'none');
                $('.logo-mini').css('display', 'inline-block');
                sessionStorage.setItem('sidebar-toggle-collapsed', '1');
            }
        }
    });

    if (!$('body').hasClass('minified')) {
        if (Boolean(sessionStorage.getItem('sidebar-toggle-collapsed'))) {
            $('.logo-lg').css('display', 'none');
            $('.logo-mini').css('display', 'inline-block');
        } else {
            $('.logo-lg').css('display', 'inline-block');
            $('.logo-mini').css('display', 'none');
        }
    }

    minified();
    $(window).resize(function() {
        minified();
    });

    function minified()
    {
        if ($(window).width() < 768) {
            $('body').addClass('minified');
        } else {
            $('body').removeClass('minified');
        }
    }

    // To make Pace works on Ajax calls
    $(document).ajaxStart(function () {
        Pace.restart();
    });

    // Ajax calls should always have the CSRF token attached to them, otherwise they won't work
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // Set active state on menu element
    var current_url = "{{ Request::fullUrl() }}";
    var full_url = current_url + location.search;
    var $navLinks = $("ul.sidebar-menu li a");
    // First look for an exact match including the search string
    var $curentPageLink = $navLinks.filter(
        function () {
            return $(this).attr('href') === full_url;
        }
    );
    // If not found, look for the link that starts with the url
    if (!$curentPageLink.length > 0) {
        $curentPageLink = $navLinks.filter(
            function () {
                return $(this).attr('href').startsWith(current_url) || current_url.startsWith($(this).attr('href'));
            }
        );
    }

    $curentPageLink.parents('li').addClass('active');
            {{-- Enable deep link to tab --}}
    var activeTab = $('[href="' + location.hash.replace("#", "#tab_") + '"]');
    location.hash && activeTab && activeTab.tab('show');
    $('.nav-tabs a').on('shown.bs.tab', function (e) {
        location.hash = e.target.hash.replace("#tab_", "#");
    });


    (function ($) {
        $(function () {
            // Custom select box
            $("#object_form, #lang_form, #crudTable_length select").selectmenu({
                change: function (event, data) {
                    $(this).trigger('change');
                }
            });

            $(document).on('init.dt', function (e, settings) {
                $("#lang_form, #crudTable_length select").selectmenu({
                    change: function (event, data) {
                        $(this).trigger('change');
                    }
                });
            });

            $(window).resize(function () {
                $("#object_form, #lang_form, #crudTable_length select").selectmenu("close");
            });

            // Modal image
            $('.js-modal-image').on('click', function () {
                /*                    $(".ui-dialog-content").dialog("close");
                                    var $target = $($(this).data('target'));
                                    $target.dialog();
                                    return false;*/
            });

            // Collapse image
            $('.js-illustration-group-trigger').on('click', function () {
                var text = $(this).data('text'),
                    oldText = $(this).text();

                $(this).data('text', oldText);
                $(this).text(text);

                $(this).closest('.illustration-group').find('.illustration-group__wrapper').slideToggle(300);
            });
        });
    })(jQuery);
</script>

<script>
    // Disable the Back-Forward-Cache of Firefox and Safari
    window.addEventListener('unload', function () {
    });
</script>

@include('backpack::inc.alerts')

@yield('after_scripts')
@stack('after_scripts')

<script>
    $('#crudTable').css('width', '100%');
</script>

<!-- JavaScripts -->
{{-- <script src="{{ elixir('js/app.js') }}"></script> --}}
</body>
</html>
