<div class="navbar-custom-menu pull-left">
    <ul class="nav navbar-nav">
        <!-- =================================================== -->
        <!-- ========== Top menu items (ordered left) ========== -->
        <!-- =================================================== -->

        <!-- <li><a href="{{ url('/') }}"><i class="fa fa-home"></i> <span>Home</span></a></li> -->

        <!-- ========== End of top menu left items ========== -->
    </ul>
</div>

<!-- Sidebar toggle button-->
<a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
    <span class="sr-only">{{ trans('backpack::base.toggle_navigation') }}</span>
    <span class="icon-bar"></span>
    <span class="icon-bar"></span>
    <span class="icon-bar"></span>
</a>

@php
    $ukName = Config::get('settings.company_name');
@endphp
<div class="uk-name header-navbar-title">{{ $ukName }}</div>
    <div class="header-navbar-controls">
        <div class="projects">
            <select class="form-control input-sm" id="object_form">
                @foreach($objects as &$object)
                    @if($object['id'] == $current_object_id)
                        <option selected value="{{$object['id']}}">{{$object['name']}} ({{$object['address']}})</option>
                    @else
                        <option value="{{$object['id']}}">{{$object['name']}} ({{$object['address']}})</option>
                    @endif
                @endforeach
            </select>
        </div>
        @php
            $current_locale = strtolower(App::getLocale());
            $langs = DB::table('settings')->where('key','active_locales')->pluck('value');
        if (count($langs) == 0) {
            $langs = [env('locale')];
        } else {
            $langs = explode(',', json_decode($langs)[0]);
        }
        foreach ($langs as &$lang) {
            $lang = strtolower(trim($lang));
        }
        @endphp
        <div class="langs">
            <select class="form-control input-sm" id="lang_form">
                @foreach($langs as &$lang)
                    @if ($lang == $current_locale)
                        <option selected value="{{$lang}}">{{$lang}}</option>
                    @else
                        <option value="{{$lang}}">{{$lang}}</option>
                    @endif
                @endforeach
            </select>
        </div>
    </div>
    <ul class="nav header-navbar-info">
      <!-- ========================================================= -->
      <!-- ========== Top menu right items (ordered left) ========== -->
      <!-- ========================================================= -->

      <!-- <li><a href="{{ url('/') }}"><i class="fa fa-home"></i> <span>Home</span></a></li> -->

        @if (Auth::guest())
            <li><a href="{{ url(config('backpack.base.route_prefix', 'admin').'/login') }}">{{ trans('backpack::base.login') }}</a></li>
            @if (config('backpack.base.registration_open'))
            <li><a href="{{ url(config('backpack.base.route_prefix', 'admin').'/register') }}">{{ trans('backpack::base.register') }}</a></li>
            @endif
        @else
            <li class="user-info">
                {{--<i class="fa fa-btn fa-circle-o fa-2x"></i><span>{{ Auth::user()->name }}</span>--}}

                    <img src="https://placehold.it/40x40/0dc9e5/ffffff/&text={{ strtoupper(mb_substr(Auth::user()->name, 0, 1)) }}" class="img-circle" alt="User Image">

                    <span>{{ Auth::user()->name }}</span>

            </li>
            <li><a href="{{ url(config('backpack.base.route_prefix', 'admin').'/logout') }}"><i class="fa fa-btn fa-sign-out"></i> {{ trans('backpack::base.logout') }}</a></li>

        @endif


       <!-- ========== End of top menu right items ========== -->
    </ul>
