@extends('backpack::layout')

@section('header')
    <section class="content-header">
        <h1>{{ trans('apartments.generation.title') }}</h1>
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="box">
                <div class="box-body">
                    @include('apartment.generation.form_generation')
                </div>

                <div class="box-body">
                    @if(!empty($apartments))
                        @include('apartment.generation.form_create')
                    @endif
                </div>
            </div><!-- /.box-->
        </div>
    </div>
    <div class="preloader">
        <div class="preloader__info">
            <img src="/assets/preloader.gif"  class="preloader__image">
            {{--<div class="preloader__info-fields">--}}
                {{--<span class="js-preloader-complete">0</span> - <span class="js-preloader-total">0</span>--}}
            {{--</div>--}}
        </div>
    </div>
@endsection


@section('after_styles')
    <link rel="stylesheet" href="{{ asset('vendor/backpack/crud/css/crud.css') }}">
    <style>
        .preloader {
            display: none;
            position: fixed;
            top: 0;
            bottom: 0;
            left: 0;
            right: 0;
            background: rgba(0,0,0,0.6);
            z-index: 5000;
            align-items: center;
            justify-content: center;
        }
        .preloader_state_open {
            display: flex;
        }
        .preloader__image {
            display: block;
            margin: 0 auto 20px;
            max-width: 100%;
        }
        .preloader__info {
            color: #fff;
            font-size: 20px;
            line-height: 1.2;
            text-align: center;
        }
    </style>
@endsection

@section('after_scripts')
    <script>
        $( document ).ready(function() {
            checkEmptyEntranceGroup();
            toggleFormSumbit();
            checkMaxActionvationPerApartment();

            var $remove = $('.js-remove-apartment'),
                $nameField = $('.js-ap-name'),
                $activationLimitField = $('.js-ap-activation-limit'),
                $generateField = $('.js-ap-generate-field'),
                apartmentsTotal = $('.js-number_apartments').text() || 0;

            $('.js-preloader-total').text(apartmentsTotal);

            $generateField.on('keyup change', function() {
                checkMaxActionvationPerApartment();
            });

            $generateField.on('change', function() {
                var text = $(this).val();
                text = $.trim(text);

                if((text == '' || text == 0) && $(this).attr('name') !== 'activation_limit') {
                    $(this).val('1').change();
                }
            });

            $remove.on('click', function () {
                var $row = $(this).closest('tr'),
                    result = confirm('{{ trans('crud.delete_confirm') }}');

                if(result) {
                    $row.remove();
                    removeLocalApartment($(this).data('id'));

                    $('.js-ap-name').each(function (index) {
                        var isnum = /^\d+$/.test($(this).val());
                        if(isnum) $(this).val(index + 1);
                    });
                }

                checkEmptyEntranceGroup();
                checkIssetsApartmentsFields();
                calculateActivations();

                return false;
            });

            function removeLocalApartment(id) {

                if(typeof id !== 'undefined') {
                    $.ajax({
                        async: false,
                        dataType: 'json',
                        method: 'GET',
                        data: {
                            id: id
                        },
                        url: '/admin/apartment-generation-remove',
                        success: function (data) {
                            console.log(data);
                            var countFlats = $('#apartmentsForm').find('.js-ap-name').length;
                            $('.js-number_apartments').text(countFlats)
                        }
                    });
                }

            }

            function checkEmptyEntranceGroup() {
                var $entranceGroup = $('.entrance-group');

                $entranceGroup.each(function () {
                    var $rows = $(this).find('tr').not('.ga-header');

                    if($rows.length == 0) {
                        $(this).remove();
                    }
                });

                // checkIssetsApartmentsFields();
            }

            function checkIssetsApartmentsFields() {
                var $apartmentsForm = $('#apartmentsForm'),
                $inputs = $apartmentsForm.find('.dataTable input');

                if($inputs.length == 0) {
                    $apartmentsForm.remove();
                }
            }

            $nameField.on('keyup', function () {
                checkNamesDuplicate();
                toggleFormSumbit()
            });

            $activationLimitField.on('keyup', function () {
                if(!$(this).val()) {
                    $(this).val('0');
                }

                calculateActivations();
                checkExcessiveActivationsValue();
                toggleFormSumbit()
            });

            function calculateActivations() {
                var total = 0;

                $('.js-ap-activation-limit').each(function () {
                    var fieldVal = parseInt($(this).val()) || 0;

                    total += fieldVal;
                });

                $('.js-required_number_activations').text(total);
                $('#maxActivationPerApartment').text(total);
            }

            function checkExcessiveActivationsValue() {
                var total = parseInt($('.js-total_available_activations').text()) || 0,
                    current = parseInt($('.js-required_number_activations').text()) || 0;

                if(current >total) {
                    $('.js-ap-activation-limit').closest('.form-group').addClass('has-error');
                    $('.js-total_available_activations, .js-required_number_activations').closest('tr').addClass('text-danger');
                } else {
                    $('.js-ap-activation-limit').closest('.form-group').removeClass('has-error');
                    $('.js-total_available_activations, .js-required_number_activations').closest('tr').removeClass('text-danger');
                }
            }
            
            function checkNamesDuplicate() {
                var listNames = [];

                $('.js-ap-name').each(function () {
                    var text = $(this).val();

                    listNames.push($.trim(text));
                });

                var duplicates = findDuplicateInArray(listNames);

                if(duplicates.length) {
                    $('.js-ap-name').each(function () {
                        var text = $(this).val();

                        if(arraySearch(duplicates, text) >= 0) {
                            $(this).closest('.form-group').addClass('has-error');
                        }
                    });
                } else {
                    $('.js-ap-name').closest('.form-group').removeClass('has-error');
                }

            }

            function findDuplicateInArray(arr) {
                var object = {};
                var result = [];

                arr.forEach(function (item) {
                    if(!object[item])
                        object[item] = 0;
                    object[item] += 1;
                })

                for (var prop in object) {
                    if(object[prop] >= 2) {
                        result.push(prop);
                    }
                }

                return result;

            }

            function arraySearch(array, value) {
                if (array.indexOf) { // если метод существует
                    return array.indexOf(value);
                }

                for (var i = 0; i < array.length; i++) {
                    if (array[i] === value) return i;
                }

                return -1;
            }

            function toggleFormSumbit() {
                var $errors = $('#apartmentsForm .has-error');

                if($errors.length) {
                    $('#saveButton').prop('disabled', true);
                } else {
                    $('#saveButton').prop('disabled', false);
                }
            }

            function checkMaxActionvationPerApartment() {
                var $maxActivationsContainer = $('#maxActivationLimit'),
                    $apartmentsNumberContainer = $('#maxActivationPerApartment'),
                    numberEntrances = $('input[name="number_entrances"]').val() || 0,
                    numberFloors = $('input[name="number_floors"]').val() || 0,
                    numberApartmentsPerFloors = $('input[name="number_apartments_per_floors"]').val() || 0,
                    activationLimit = parseInt($('input[name="activation_limit"]').val()) || 0,
                    maxActivations = $maxActivationsContainer.text() || 0,
                    apartmentsTotal = (numberApartmentsPerFloors * numberFloors) * numberEntrances,
                    needActivations = apartmentsTotal * activationLimit;

                    $apartmentsNumberContainer.text(needActivations);

                if(needActivations > maxActivations) {
                    $apartmentsNumberContainer.closest('div').addClass('text-danger');
                    $('#generateButton').prop('disabled', true);
                } else {
                    $apartmentsNumberContainer.closest('div').removeClass('text-danger');
                    $('#generateButton').prop('disabled', false);
                }
            }

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            
            $('#saveButton').on('click', function () {
                if (localStorage.getItem('apartmentSaveActive') != 'Y') {
                    saveItems();
                } else {
                    $('.preloader').addClass('preloader_state_open');
                }
                return false;
            });

            function saveItems() {
                localStorage.setItem('apartmentSaveActive', 'Y');
                var $groups = $('#apartmentsForm .entrance-group'),
                    $preloader = $('.preloader'),
                    $step = $('#apartmentsForm .steps').val();

                if($groups.length) {
                    $preloader.addClass('preloader_state_open');
                    var $fields = $($groups[$step]).find('.js-ap-name, .js-ap-activation-limit');
                    if($fields.length) {
                        setTimeout(function () {
                            var data = $fields.serializeArray();
                            $.ajax({
                                dataType: 'json',
                                method: 'POST',
                                data: data,
                                url: '/admin/apartment-generation-save',
                                success: function (data) {
                                    console.log(data);
                                    ++$step;
                                    if ($step < $groups.length) {
                                        $('#apartmentsForm .steps').val($step);
                                        localStorage.setItem('apartmentSaveActive', 'N');
                                        $('#saveButton').trigger('click');
                                    } else {
                                        localStorage.removeItem('apartmentSaveActive');
                                        $.ajax({
                                            async: false,
                                            dataType: 'json',
                                            method: 'GET',
                                            url: '/admin/apartment-generation-finish',
                                            success: function (data) {
                                                console.log('finish', data);
                                                $preloader.removeClass('preloader_state_open');
                                                window.location = window.location.href;
                                            }
                                        });
                                    }
                                },
                                error: function() {
                                    localStorage.removeItem('apartmentSaveActive');
                                }
                            });
                        }, 1000);
                    } else {
                      ++$step;
                      $('#apartmentsForm .steps').val($step);
                      localStorage.setItem('apartmentSaveActive', 'N');
                      $('#saveButton').trigger('click');
                    }
                }
            }

            /*window.onbeforeunload = function () {
                if($('#apartmentsForm').length && !$('.preloader').hasClass('preloader_state_open')) {
                    return "Do you really want to close?";
                }
            };*/

            @if($save_numbers > 0)
                if (localStorage.getItem('apartmentSaveActive') != 'Y') {
                    saveItems();
                }
            @endif

            window.onunload = function() {
                localStorage.removeItem('apartmentSaveActive');
            }


        });
    </script>
@endsection
