<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Языковые ресурсы для проверки значений
    |--------------------------------------------------------------------------
    |
    | Последующие языковые строки содержат сообщения по-умолчанию, используемые
    | классом, проверяющим значения (валидатором). Некоторые из правил имеют
    | несколько версий, например, size. Вы можете поменять их на любые
    | другие, которые лучше подходят для вашего приложения.
    |
    */

    'accepted' => 'Вы должны принять :attribute.',
    'active_url' => 'Поле :attribute содержит недействительный URL.',
    'after' => 'В поле :attribute должна быть дата после :date.',
    'after_or_equal' => 'В поле :attribute должна быть дата после или равняться :date.',
    'alpha' => 'Поле :attribute может содержать только буквы.',
    'alpha_dash' => 'Поле :attribute может содержать только буквы, цифры и дефис.',
    'alpha_num' => 'Поле :attribute может содержать только буквы и цифры.',
    'array' => 'Поле :attribute должно быть массивом.',
    'before' => 'В поле :attribute должна быть дата до :date.',
    'before_or_equal' => 'В поле :attribute должна быть дата до или равняться :date.',
    'between' => [
        'numeric' => 'Поле :attribute должно быть между :min и :max.',
        'file' => 'Размер файла в поле :attribute должен быть между :min и :max Килобайт(а).',
        'string' => 'Количество символов в поле :attribute должно быть между :min и :max.',
        'array' => 'Количество элементов в поле :attribute должно быть между :min и :max.',
    ],
    'boolean' => 'Поле :attribute должно иметь значение логического типа.',
    // калька 'истина' или 'ложь' звучала бы слишком неестественно
    'confirmed' => 'Поле :attribute не совпадает с подтверждением.',
    'date' => 'Поле :attribute не является датой.',
    'date_format' => 'Поле :attribute не соответствует формату :format.',
    'different' => 'Поля :attribute и :other должны различаться.',
    'digits' => 'Длина цифрового поля :attribute должна быть :digits.',
    'digits_between' => 'Длина цифрового поля :attribute должна быть между :min и :max.',
    'dimensions' => 'Поле :attribute имеет недопустимые размеры изображения.',
    'distinct' => 'Поле :attribute содержит повторяющееся значение.',
    'email' => 'Поле :attribute должно быть действительным электронным адресом.',
    'file' => 'Поле :attribute должно быть файлом.',
    'filled' => 'Поле :attribute обязательно для заполнения.',
    'exists' => 'Значение для :attribute не найдено в базе данных системы.',
    'image' => 'Поле :attribute должно быть изображением.',
    'in' => 'Выбранное значение для :attribute ошибочно.',
    'in_array' => 'Поле :attribute не существует в :other.',
    'integer' => 'Поле :attribute должно быть целым числом.',
    'ip' => 'Поле :attribute должно быть действительным IP-адресом.',
    'isexists' => 'Выбранный элемент :attribute не существует',
    'json' => 'Поле :attribute должно быть JSON строкой.',
    'max' => [
        'numeric' => 'Поле :attribute не может быть более :max.',
        'file' => 'Размер файла в поле :attribute не может быть более :max Килобайт(а).',
        'string' => 'Количество символов в поле :attribute не может превышать :max.',
        'array' => 'Количество элементов в поле :attribute не может превышать :max.',
    ],
    'mimes' => 'Поле :attribute должно быть файлом одного из следующих типов: :values.',
    'mimetypes' => 'Поле :attribute должно быть файлом одного из следующих типов: :values.',
    'min' => [
        'numeric' => 'Поле :attribute должно быть не менее :min.',
        'file' => 'Размер файла в поле :attribute должен быть не менее :min Килобайт(а).',
        'string' => 'Количество символов в поле :attribute должно быть не менее :min.',
        'array' => 'Количество элементов в поле :attribute должно быть не менее :min.',
    ],
    'not_in' => 'Выбранное значение для :attribute ошибочно.',
    'numeric' => 'Поле :attribute должно быть числом.',
    'present' => 'Поле :attribute должно присутствовать.',
    'regex' => 'Поле :attribute имеет ошибочный формат.',
    'required' => 'Поле :attribute обязательно для заполнения.',
    'required_if' => 'Поле :attribute обязательно для заполнения, когда :other равно :value.',
    'required_unless' => 'Поле :attribute обязательно для заполнения, когда :other не равно :values.',
    'required_with' => 'Поле :attribute обязательно для заполнения, когда :values указано.',
    'required_with_all' => 'Поле :attribute обязательно для заполнения, когда :values указано.',
    'required_without' => 'Поле :attribute обязательно для заполнения, когда :values не указано.',
    'required_without_all' => 'Поле :attribute обязательно для заполнения, когда ни одно из :values не указано.',
    'same' => 'Значение :attribute должно совпадать с :other.',
    'singly_check_in_product' => "Количество значений поля ':attribute' с параметром 'Внешний вариант превысило установленное значение.'",
    'size' => [
        'numeric' => 'Поле :attribute должно быть равным :size.',
        'file' => 'Размер файла в поле :attribute должен быть равен :size Килобайт(а).',
        'string' => 'Количество символов в поле :attribute должно быть равным :size.',
        'array' => 'Количество элементов в поле :attribute должно быть равным :size.',
    ],
    'string' => 'Поле :attribute должно быть строкой.',
    'timezone' => 'Поле :attribute должно быть действительным часовым поясом.',
    'unique' => 'Такое значение поля :attribute уже существует.',
    'uploaded' => 'Загрузка поля :attribute не удалась.',
    'url' => 'Поле :attribute имеет ошибочный формат.',
    'rtspurl' => 'Поле ":attribute" имеет ошибочный формат.',
    'rtspname' => 'Поле ":attribute" содержит недопустимые символы (допустимо: a-z 0-9 $ _ . + = - * ! \' ( ) ; ? &)',
    'rtsppassword' => 'Поле ":attribute" содержит недопустимые символы (допустимо: a-z 0-9 $ _ . + = - * ! \' ( ) ; ? &)',
    'phone' => 'Поле :attribute содержит недействительный номер телефона.',


    'attributes' => [
        'name' => 'Имя',
        'email' => 'Почта',
        'password' => 'Пароль',
        'theme' => 'тема',
        'text' => 'текст',
        'actual_from_date' => 'актуально с',
        'actual_to_date' => 'актуально по',
        'destinations' => 'получатели',
        'title' => 'название',
        'start_at' => 'дата начала',
        'end_at' => 'дата окончания',
        'question' => 'вопрос',
        'apartment' => 'квартира',
        'claim' => 'заявка',
        'need_at' => 'дата проведения работ',
        'type' => 'тип',
        'phone' => 'телефон',
        'rtsp_link_type' => 'RTSP ссылка',
        'has_second_relay' => 'Есть второе реле?',
        'number' => 'Номер квартиры',
        'activation_code' => 'Код активации',
        'activation_limit' => 'Лимит активаций'
    ],

    'custom' => [
        'apartment' => [
            'required' => 'Укажите квартиру получателя',
        ],
        'destinations' => [
            'required_if' => 'Укажите хотя бы одного получателя',
        ],
        'answers' => [
            'required_if' => 'Заполните варианты ответов',
        ],
        'ip_address' => [
            'ip' => "Некорректный ip адрес",
        ],
        'id' => [
            'exists' => 'Некорректный id варианта ответа',
        ],
        'style_id' => [
            'required' => 'Выберите стиль отображения',
        ],
        'category_id' => [
            'required' => 'Выберите категорию',
        ],
        'value' => [
            'domain_name_or_ip' => 'Поле :attribute должно быть доменным именем или IP-адресом',
        ],
        'sip_numbers' => 'SIP-номера ',
        'already_used' => ' уже используются',
        'greater_weight_permissions' => 'У Вас недостаточно разрешений для установки такого набора прав',
    ],

    'values' => [
        'rtsp_link_type' => [
            \App\Models\CallingPanel::RTSP_LINK_TYPE_FULL => 'Полная ссылка',
            \App\Models\CallingPanel::RTSP_LINK_TYPE_PARAMETERS => 'Параметры',
        ],
        'has_second_relay' => [
            0 => 'Нет',
            1 => 'Да',
        ],
    ],

    'users' => [
        'not_possible_role' => 'Вы не можете установить отсутствующие у вас роли',
        'not_possible_permission' => 'Вы не можете изменять отсутствующие у вас права',
        'is_active' => 'Вы не можете изменить маркер активности пользователя'
    ]
];
