<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Языковые ресурсы для проверки значений
    |--------------------------------------------------------------------------
    |
    | Последующие языковые строки содержат сообщения по-умолчанию, используемые
    | классом, проверяющим значения (валидатором). Некоторые из правил имеют
    | несколько версий, например, size. Вы можете поменять их на любые
    | другие, которые лучше подходят для вашего приложения.
    |
    */

    'accepted' => 'Jums jāpieņem :attribute.',
    'active_url' => 'Lauks :attribute satur nederīgu URL.',
    'after' => 'Laukā :attribute jābūt datumam pēc :date.',
    'after_or_equal' => 'Laukā :attribute jābūt datumam pēc vai būt vienādiem :date.',
    'alpha' => 'Lauks :attribute var saturēt tikai burtus.',
    'alpha_dash' => 'Lauks :attribute var saturēt tikai burtus, ciparus un defisi.',
    'alpha_num' => 'Lauks :attribute var saturēt tikai burtus un ciparus.',
    'array' => 'Lauks :attribute jābūt masīvam.',
    'before' => 'Laukā :attribute jābūt datumam pirms :date.',
    'before_or_equal' => 'Laukā :attribute jābūt datumam pirms vai būt vienādiem :date.',
    'between' => [
        'numeric' => 'Lauks :attribute jābūt starp :min un :max.',
        'file' => 'Faila izmers laukā :attribute jābūt starp :min un :max Kilobīti.',
        'string' => 'Simbolu skaits laukā :attribute jābūt starp :min un :max.',
        'array' => 'Laukā esošo vienību skaits :attribute jābūt starp :min un :max.',
    ],
    'boolean' => 'Lauks :attribute jābūt loģiskam.',
    // калька 'истина' или 'ложь' звучала бы слишком неестественно
    'confirmed' => 'Lauks :attribute neatbilst apstiprinājumam.',
    'date' => 'Lauks :attribute nav datums.',
    'date_format' => 'Lauks :attribute neatbilst formātam :format.',
    'different' => 'Lauki :attribute un :other jābūt atšķirīgam.',
    'digits' => 'Ciparu lauka garums :attribute jābūt :digits.',
    'digits_between' => 'Ciparu lauka garums :attribute jābūt starp :min un :max.',
    'dimensions' => 'Lauks :attribute satur nederīgi attēla izmēri.',
    'distinct' => 'Lauks :attribute satur atkārtotu vērtību.',
    'email' => 'Lauks :attribute jābūt derīgai e-pasta adresei.',
    'file' => 'Lauks :attribute jābūt failam.',
    'filled' => 'Lauks :attribute obligāts.',
    'exists' => 'Vērtība :attribute nav atrasts sistēmas datu bāzē.',
    'image' => 'Lauks :attribute vajadzētu būt attēlam.',
    'in' => 'Atlasīta vērtība :attribute nepareiza.',
    'in_array' => 'Lauks :attribute neeksistē :other.',
    'integer' => 'Lauks :attribute jābūt veselam skaitlim.',
    'ip' => 'Lauks :attribute jābūt deramai IP adresei.',
    'isexists' => 'Atlasīts vienums :attribute neeksistē',
    'json' => 'Lauks :attribute jābūt JSON pēc virknes.',
    'max' => [
        'numeric' => 'Lauks :attribute nevar būt vairāk :max.',
        'file' => 'Lauka faila izmērs :attribute nevar būt vairāk :max Kilobīti.',
        'string' => 'Laukā simbolu skaits :attribute nevar būt lielāks :max.',
        'array' => 'Laukā esošo vienību skaits :attribute nevar būt lielāks :max.',
    ],
    'mimes' => 'Lauks :attribute jābūt vienam no šādiem tipiem: :values.',
    'mimetypes' => 'Lauks :attribute jābūt vienam no šādiem tipiem: :values.',
    'min' => [
        'numeric' => 'Lauks :attribute jābūt vismaz :min.',
        'file' => 'Faila izmērs laukā :attribute jābūt vismaz :min Kilobīti.',
        'string' => 'Laukā simbolu skaits :attribute jābūt vismaz :min.',
        'array' => 'Laukā esošo vienību skaits :attribute jābūt vismaz :min.',
    ],
    'not_in' => 'Atlasīta vērtība :attribute nepareiza.',
    'numeric' => 'Lauks :attribute jābūt skaitlim.',
    'present' => 'Lauks :attribute jābūt.',
    'regex' => 'Lauks :attribute satur kļūdainu formātu.',
    'required' => 'Lauks :attribute obligāts.',
    'required_if' => 'Lauks :attribute jāaizpilda, kad :other vienads ar :value.',
    'required_unless' => 'Lauks :attribute jāaizpilda, kad :other nav vienads ar :values.',
    'required_with' => 'Lauks :attribute jāaizpilda, kad :values norādīts.',
    'required_with_all' => 'Lauks :attribute jāaizpilda, kad :values norādīts.',
    'required_without' => 'Lauks :attribute jāaizpilda, kad :values nav norādīts.',
    'required_without_all' => 'Lauks :attribute jāaizpilda, kad neviens no :values nav norādīts.',
    'same' => 'Vienība :attribute jāatbilst ar :other.',
    'singly_check_in_product' => "Lauka vērtību skaits ':attribute' ar parametru 'Ārējā opcija pārsniedz iestatīto vērtību.'",
    'size' => [
        'numeric' => 'Lauks :attribute jābūt vienādam :size.',
        'file' => 'Lauka faila izmērs :attribute jābūt vienādam :size Kilobīti.',
        'string' => 'Laukā simbolu skaits :attribute jābūt vienādam :size.',
        'array' => 'Laukā esošo vienību skaits :attribute jābūt vienādam :size.',
    ],
    'string' => 'Lauks :attribute jābūt virknei.',
    'timezone' => 'Lauks :attribute jābūt derīgai laika zonai.',
    'unique' => 'Šī lauka vērtība :attribute jau eksistē.',
    'uploaded' => 'Pielādes lauks :attribute neizdevās.',
    'url' => 'Lauks :attribute satur kļūdainu formātu.',
    'rtspurl' => 'Lauks ":attribute" satur kļūdainu formātu.',
    'rtspname' => 'Lauks ":attribute" satur nederīgus simbolus (derīgas: a-z 0-9 $ _ . + = - * ! \' ( ) ; ? &)',
    'rtsppassword' => 'Lauks ":attribute" содержит недопустимые символы (derīgas: a-z 0-9 $ _ . + = - * ! \' ( ) ; ? &)',
    'phone' => 'Lauks :attribute satur neeksistējošo tālruņa numuru.',


    'attributes' => [
        'name' => 'Vārds',
        'email' => 'Pasts',
        'password' => 'Parole',
        'theme' => 'tēma',
        'text' => 'teksts',
        'actual_from_date' => 'aktuāli no',
        'actual_to_date' => 'aktuāli līdz',
        'destinations' => 'saņēmēji',
        'title' => 'nosaukums',
        'start_at' => 'sākuma datums',
        'end_at' => 'beigu datums',
        'question' => 'jautājums',
        'apartment' => 'dzīvoklis',
        'claim' => 'pieteikums',
        'need_at' => 'darba datums',
        'type' => 'veids',
        'phone' => 'telefons',
        'rtsp_link_type' => 'RTSP saite',
        'has_second_relay' => 'Vai ir otrs relejs?',
        'number' => 'Dzīvokļa numurs',
        'activation_code' => 'Aktivizācijas kods',
        'activation_limit' => 'Aktivizācijas limits'
    ],

    'custom' => [
        'apartment' => [
            'required' => 'Norādiet dzīvokļa numuru',
        ],
        'destinations' => [
            'required_if' => 'Norādiet vismaz vienu saņēmēju',
        ],
        'answers' => [
            'required_if' => 'Aizpildiet atbildes iespējas',
        ],
        'ip_address' => [
            'ip' => "Nepareiza ip adrese",
        ],
        'id' => [
            'exists' => 'Nepareizs atbildes id',
        ],
        'style_id' => [
            'required' => 'Izvēlieties displeja stilu',
        ],
        'category_id' => [
            'required' => 'Izvēlieties kategoriju',
        ],
        'value' => [
            'domain_name_or_ip' => 'Lauks :attribute jābūt domēna nosaukumam vai IP-edresem',
        ],
        'sip_numbers' => 'SIP-numurs ',
        'already_used' => ' jau izmantots',
        'greater_weight_permissions' => 'Jums nav pietiekamu atļauju, lai instalētu šo tiesību kopu',
    ],

    'values' => [
        'rtsp_link_type' => [
            \App\Models\CallingPanel::RTSP_LINK_TYPE_FULL => 'Palna saite',
            \App\Models\CallingPanel::RTSP_LINK_TYPE_PARAMETERS => 'Parametri',
        ],
        'has_second_relay' => [
            0 => 'Nē',
            1 => 'Jā',
        ],
    ],

    'users' => [
        'not_possible_role' => 'Jūs nevarat instalēt trūkstošās lomas',
        'not_possible_permission' => 'Jūs nevarat mainīt savas trūkstošās tiesības',
        'is_active' => 'Jūs nevarat mainīt lietotāja aktivitātes simbolu'
    ]
];
