<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Apartments Manager Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used for Laravel Backpack - Apartments
    | Author: Andrey Golikov <agolikov@smartru.com>
    |
    */

    'apartments' => 'Apartments',
    'apartment' => 'Apartment',
    'apartment_singular' => 'apartment',
    'apartment_singular_2' => 'apartment',
    'apartment_singular_3' => 'apartment',
    'apartment_plural' => 'apartments',
    'apartment_plural_2' => 'apartments',
    'sip_number_not_found' => 'no SIP number, attached to device',
    'from' => 'of',
    'activity' => 'Activity',
    'export_to_excel' => 'Export to Excel',
    'generating' => 'generating...',
    'licences' => 'Licences',
    'activated_by_users' => 'activated by users',
    'connected_to_apartments' => 'connected to apartments',
    'total' => 'total',

    'crud_fields' => [
        'number' => 'Number',
        'entrance' => 'Entrance',
        'floor' => 'Floor',
        'activation_code' => 'Activation code',
        'activation_limit' => 'Activation limit',
        'activations_used' => 'Activations num',
        'activations' => 'Activations',
        'sip_numbers' => 'SIP-numbers',
        'sip_activated' => 'Connected',
        'sip_number_add_button' => 'SIP number',
        'sip_number' => 'SIP-number',
        'sip_password' => 'Password',
        'select_devices' => 'Selected devices',
        'add' => 'Add',
        'select_calling_panels' => 'Available calling panels',
        'select_cameras' => 'Available cameras',
        'binding_to_apartments' => 'Binding to apartments',
        'select_all' => 'Select all',
    ],
    'crud_buttons' => [
        'reset_activations' => 'Reset Activations',
        'reset_code' => 'Reset Code',
    ],
    'validation' => [
        'unique_with' => 'In this project there is an apartment with this number',
        'activation_limit' => 'The "Activation limit" field can not be less than number of activations at current moment',
        'activation_limit_now' => 'now',
        'too_much_activation' => 'The maximum number of activations has been exceeded, please reduce the number of activations',
        'number_example' => 'Example: 430, 12a, 103G.',
        'not_unique_sip_number' => 'SIP-number :number should not be repeated.',
        'not_unique_sip_numbers' => 'SIP-numbers :numbers should not be repeated.',
        'sip_number_already_exists' => 'SIP-number :number already exists.',
        'sip_numbers_already_exists' => 'SIP-numbers :numbers already exists.',
        'sip_numbers_empty_rows' => 'SIP-numbers can not be empty',
        'sip_password_empty' => 'SIP-number\' :number password can not be empty.',
        'sip_passwords_empty' => 'SIP numbers :numbers can not have empty passwords.',
        'sip_numbers_is_to_long' => 'Length of a SIP number can not exceed :symbols characters',
        'sip_passwords_is_to_long' => 'Length of a SIP password can not exceed :symbols characters',
    ],

    // Confirmation messages and bubbles
    'activation_quota_exceeded' => 'Activation quota exceeded',
    'reset_confirm' => 'Are you sure you want to reset activations?',
    'reset_confirmation_title' => 'Activations reseted',
    'reset_confirmation_message' => 'The activations has been reseted successfully.',
    'reset_confirmation_not_title' => 'NOT reseted',
    'reset_confirmation_not_message' => "There's been an error. Your activations might not have been reseted.",
    'reset_confirmation_not_reset_title' => 'Not reseted',
    'reset_confirmation_not_reset_message' => 'Nothing happened. Activations is safe.',
    'reset_confirmation_no_reset_title' => 'No activations',
    'reset_confirmation_no_reset_message' => 'There are no activations yet',

    'activations' => [
        'used' => 'Used',
        'activations_from' => 'activations of',
        'acs_no_answer' => 'It is impossible to display a number of available activations, there is no connection from the activation code servers'
    ],

    'validate' => [
        'required' => 'The field is required',
        'numeric' => 'The entrances must be a number',
        'not_in' => 'The entrances is invalid',
    ],

    'generation' => [
        'title' => 'Batch generation of apartments',
        'number_entrances' => 'Number of entrances',
        'number_floors' => 'Number of floors',
        'number_apartments_per_floors' => 'Number of apartments per floor',
        'number_apartments' => 'Number of apartments',
        'activation_limit' => 'Number of activations per apartment',
        'required_number_activations' => 'The required number of activations',
        'generate' => 'Generate',
        'nav_text' => 'Multiple generation',
        'total' => 'Total activations available:',
        'current_total' => 'required',
        'stores_link' => 'Click to continue batch generation of apartments.',
        'stores' => 'The number of unsaved apartments: :save_number.',
    ],

    'do_not_read_advert' => 'Flats that didn\'t read announcemen',

];
