/*
*
* Backpack destinations component
*
*/

jQuery(function ($) {

    'use strict';


    var destList = $('.destinations-list');
    var isAllHouse = $('#is_all_house-field');
    var destField = $('#destinations-field');
    var addDestinationBtn = $('#add-destination');
    var addDestinationGroupBtn = $('#add-destination-group');

    var entranceField = $('#entrance-field');
    var apartmentField = $('#apartment-field');
    var floorField = $('#floor-field');

    var isEditForm = destList.closest('.edit-form').length > 0;

    // ---------------- EVENTS ----------------

    isAllHouseChecked();
    if (destField.val()) {
        fillDestinations();
    }
    isAllHouse.on('change', isAllHouseChecked);
    addDestinationBtn.on('click', addApartment);
    addDestinationGroupBtn.on('click', addDestinationGroup);
    destList.on('click', 'i.remove', removeDestination);


    // ---------------- HANDLERS ----------------

    function fillDestinations() {
        var destinations = JSON.parse(destField.val());
        var destFields = {};
        $.each(destinations, function (index, value) {
            if (value.is_all_house == 1) {
                destList.text('Всему дому');
                return;
            }
            destFields = {
                apartment: {
                    val: value.apartment,
                    text: apartmentField.find('option[value="' + value.apartment + '"]').text()
                },
                entrance: {
                    val: value.entrance,
                    text: entranceField.find('option[value="' + value.entrance + '"]').text()
                },
                floor: {
                    val: value.floor,
                    text: floorField.find('option[value="' + value.floor + '"]').text()
                }
            };

            var destName = getDestinationName(destFields);
            var attrs = getDestinationAttrs(destFields);
            destList.append(getDestinationHtml(destName, attrs));
        });
    }

    function removeDestination() {
        $(this).closest('h4').remove();
    }

    function addDestinationGroup(event) {
        event.preventDefault();

        var destFields = {
            apartment: {
                val: 0,
                text: ''
            },
            entrance: {
                val: entranceField.val(),
                text: entranceField.find('option:selected').text()
            },
            floor: {
                val: floorField.val(),
                text: floorField.find('option:selected').text()
            }
        };

        addDestinationBadge(destFields);
    }

    function addApartment(event) {
        event.preventDefault();

        var destFields = {
            apartment: {
                val: apartmentField.val(),
                text: apartmentField.find('option:selected').text()
            },
            entrance: {
                val: 0,
                text: ''
            },
            floor: {
                val: 0,
                text: ''
            }
        };

        addDestinationBadge(destFields);
    }

    function addDestinationBadge(destFields) {
        var destName = getDestinationName(destFields);
        var hash = hashCode(destName);
        var attrs = getDestinationAttrs(destFields);

        if (!destName) {
            new PNotify(destinationNotifications.empty);
            return;
        }

        var existingItem = destList.find('.label[data-hash="' + hash + '"]');
        if (existingItem.length) {
            new PNotify(destinationNotifications.already_exists);
            return;
        }

        destList.append(getDestinationHtml(destName, attrs));

        setDestinationsList();
    }

    function isAllHouseChecked() {
        var name = isAllHouse.attr('name');
        isAllHouse
            .closest('form')
            .find('[data-disable="' + name + '"]')
            .prop('disabled', isAllHouse.is(':checked'));
    }


    // ---------------- FUNCTIONS ----------------

    function hashCode(str) {
        var hash = 0;
        if (str.length == 0) {
            return hash;
        }
        for (var i = 0; i < str.length; i++) {
            var char = str.charCodeAt(i);
            hash = ((hash << 5) - hash) + char;
            hash = hash & hash; // Convert to 32bit integer
        }
        return Math.abs(hash);
    }

    function setDestinationsList() {
        var dest = [];
        destList.find('span.label').each(function (index, value) {
            var $this = $(value);
            var fields = {};
            if ($this.data('apartment')) {
                fields.apartment = $this.data('apartment');
            }
            if ($this.data('floor')) {
                fields.floor = $this.data('floor');
            }
            if ($this.data('entrance')) {
                fields.entrance = $this.data('entrance');
            }
            dest.push(fields);
        });
        destField.val(JSON.stringify(dest));
    }

    function getDestinationHtml(name, attrs) {
        var hash = hashCode(name);
        var removeBtn = isEditForm ? '' : '<i class="remove glyphicon glyphicon-remove-sign glyphicon-white"></i>';
        return '<h4>' +
            '<span class="label label-primary" data-hash="' + hash + '" ' + attrs + '>' + name +
            removeBtn +
            '</span>' +
            '</h4>';
    }

    function getDestinationAttrs(destFields) {
        var attrs = '';
        $.each(destFields, function (index, field) {
            attrs += 'data-' + index + '="' + field.val + '" ';
        });

        return attrs;
    }

    function getDestinationName(destFields) {
        var destName = '';
        if (destFields.apartment.val) {
            destName = destFields.apartment.text;
        }
        else {
            if (destFields.entrance.val) {
                destName = destFields.entrance.text;
            }
            if (destFields.entrance.val && destFields.floor.val) {
                destName += ' , ';
            }
            if (destFields.floor.val) {
                destName += destFields.floor.text;
            }
        }

        return destName;
    }
});
