<?php

namespace evApps\Updater\Ds\App\Console\Commands;

use Illuminate\Console\Command;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
class CheckAcsVersion extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'evapps:check-version';
    protected $client;

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check current available version on acs-server';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->client = new Client([
            'base_uri' => config('evapps.updater.remote_server.url'),
            'verify' => false
        ]);
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if(!\Cache::get('version')) {
            $headers = [
                'Accept' => 'application/json',
                'Content-Type' => 'application/json',
                'App-Licence-Key' => md5(env('APP_LICENSE_KEY'))
            ];
            try {
                $response = $this->client->request('GET', '/updater/current-version', [
                    'headers' => $headers
                ]);
                $result = \GuzzleHttp\json_decode($response->getBody()->getContents());
                \Cache::store('file')->put('version', $result->version, 20);
                return true;
            } catch (RequestException $e) {
                \Log::error('Cant\'t check current version on remote server', [$e->getMessage()]);
                return false;
            }
        }
    }
}
