<?php

namespace evApps\Updater\Ds;

use Illuminate\Support\ServiceProvider;
use evApps\Updater\Ds\App\Console\Commands\CheckAcsVersion;
use evApps\Updater\Ds\App\Console\Commands\CheckTestVersion;
use Illuminate\Console\Scheduling\Schedule;

/**
 * Created by PhpStorm.
 * User: alipinskaya
 * Date: 10.08.18
 * Time: 14:38
 */
class UpdaterDsServiceProvider extends ServiceProvider
{
    /**
     * @var string[]
     */
    protected $commands = [
        CheckAcsVersion::class,
        CheckTestVersion::class,
    ];

    /**
     * Perform post-registration booting of services.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__ . '/config' => config_path()
        ], 'config');

        $this->commands($this->commands);
        $this->app->booted(function () {
            $schedule = app(Schedule::class);
            $schedule->command('evapps:check-version')->everyMinute();
            $schedule->command('evapps:test-version')->everyMinute();
        });
        $this->loadRoutesFrom(__DIR__.'/routes/updater.php');
        $this->loadViewsFrom(__DIR__.'/resources/views', 'updater');
        $this->loadTranslationsFrom(__DIR__.'/resources/lang', 'updater');
    }

    public function register()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/config/evapps/updater.php',
            'evapps.updater.ds'
        );
    }
}