<?php

use evApps\Installer\app\Http\Utilities\Installer;

Route
    ::middleware(['web', 'installer.isNotAlreadyInstalled'])
    ->namespace('evApps\Installer\app\Http\Controllers')
    ->prefix(config('evapps.installer.route_prefix'))
    ->group(function () {
        // Set interface language
        Route::get(
            'setLocale/{locale}',
            'LocaleController@setLocale'
        )->name('evapps.installer.setLocale');

        Route::get(
            'clearCookies',
            'CookiesController@clearCookies'
        )->name('evapps.installer.clearCookies');

        Route
            ::middleware(['installer.locale'])
            ->group(function () {
                // Step 1: checking server requirements
                Route::get(
                    Installer::REQUIREMENTS_STEP . '-step',
                    'RequirementsController@showStepForm'
                )->name('evapps.installer.' . Installer::REQUIREMENTS_STEP . '-show-step-form');

                Route::post(
                    Installer::REQUIREMENTS_STEP . '-step',
                    'RequirementsController@saveStepData'
                )->name('evapps.installer.' . Installer::REQUIREMENTS_STEP . '-save-step-data');

                // Step 2: checking license key
                Route
                    ::middleware('installer.stepCompleted:' . Installer::REQUIREMENTS_STEP)
                    ->group(function () {
                        Route::get(
                            Installer::LICENSE_KEY_STEP . '-step',
                            'LicenseKeyController@showStepForm'
                        )->name('evapps.installer.' . Installer::LICENSE_KEY_STEP . '-show-step-form');

                        Route::post(
                            Installer::LICENSE_KEY_STEP . '-step',
                            'LicenseKeyController@saveStepData'
                        )->name('evapps.installer.' . Installer::LICENSE_KEY_STEP . '-save-step-data');
                    });

                // Step 3: database settings
                Route
                    ::middleware('installer.stepCompleted:' . Installer::LICENSE_KEY_STEP)
                    ->group(function () {
                        Route::get(
                            Installer::DATABASE_STEP . '-step',
                            'DatabaseController@showStepForm'
                        )->name('evapps.installer.' . Installer::DATABASE_STEP . '-show-step-form');

                        Route::post(
                            Installer::DATABASE_STEP . '-step',
                            'DatabaseController@saveStepData'
                        )->name('evapps.installer.' . Installer::DATABASE_STEP . '-save-step-data');
                    });

                // Step 4: first object creation
                Route
                    ::middleware('installer.stepCompleted:' . Installer::DATABASE_STEP)
                    ->group(function () {
                        Route::get(
                            Installer::FIRST_OBJECT_STEP . '-step',
                            'FirstObjectController@showStepForm'
                        )->name('evapps.installer.' . Installer::FIRST_OBJECT_STEP . '-show-step-form');

                        Route::post(
                            Installer::FIRST_OBJECT_STEP . '-step',
                            'FirstObjectController@saveStepData'
                        )->name('evapps.installer.' . Installer::FIRST_OBJECT_STEP . '-save-step-data');
                    });

                // Step 5: admin creation
                Route
                    ::middleware('installer.stepCompleted:' . Installer::FIRST_OBJECT_STEP)
                    ->group(function () {
                        Route::get(
                            Installer::ADMIN_STEP . '-step',
                            'AdminController@showStepForm'
                        )->name('evapps.installer.' . Installer::ADMIN_STEP . '-show-step-form');

                        Route::post(
                            Installer::ADMIN_STEP . '-step',
                            'AdminController@saveStepData'
                        )->name('evapps.installer.' . Installer::ADMIN_STEP . '-save-step-data');
                    });

                // Step 6: finish
                Route
                    ::middleware('installer.stepCompleted:' . Installer::ADMIN_STEP)
                    ->group(function () {
                        Route::get(
                            Installer::FINISH_STEP . '-step',
                            'FinishController@showStepForm'
                        )->name('evapps.installer.' . Installer::FINISH_STEP . '-show-step-form');
                    });
            });
    });
