<?php

namespace evApps\Installer\app\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Class LicenseKeyRequest
 *
 * @package evApps\Installer\app\Http\Requests
 */
class LicenseKeyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'licenseKey' => 'required|regex:/.{2,}/',
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'licenseKey' => __('installer::license_key.license_key'),
        ];
    }
}
