<?php

namespace evApps\Installer\app\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

/**
 * Class LanguagesRequest
 *
 * @package evApps\Installer\app\Http\Requests
 */
class LanguagesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'languages' => 'required|array',
            'languages.*' => [
                Rule::in(config('evapps.installer.locales'))
            ],
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'languages' => __('installer::languages.languages'),
        ];
    }
}
