<?php

namespace evApps\Installer\app\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Class FirstObjectRequest
 *
 * @package evApps\Installer\app\Http\Requests
 */
class AdminRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'     => 'required',
            'email'    => 'required|email',
            'password' => 'required|confirmed',
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'name' => __('installer::admin.name'),
            'email' => __('installer::admin.email'),
            'password' => __('installer::admin.password'),
            'password_confirmation' => __('installer::admin.password_confirmation'),
        ];
    }
}
