<?php

namespace evApps\Installer\app\Http\Middleware;

use Closure;
use evApps\Installer\app\Http\Utilities\Installer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;

/**
 * Class StepCompleted
 *
 * @package evApps\Installer\app\Http\Middleware
 */
class StepCompleted
{


    /**
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @param string $step
     *
     * @return \Illuminate\Http\RedirectResponse|mixed
     */
    public function handle(Request $request, Closure $next, string $step)
    {
        if (!Installer::isStepCompleted($step)) {
            // Redirect to step, that should be completed
            return Redirect::route('evapps.installer.' . $step . '-show-step-form');
        }

        return $next($request);
    }
}
