<?php

namespace evApps\Installer\app\Http\Controllers;

use evApps\Installer\app\Http\Utilities\Installer;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Redirect;

/**
 * Class RequirementsController
 *
 * @package evApps\Installer\app\Http\Controllers
 */
class RequirementsController extends Controller
{

    /**
     * @return array|\Illuminate\Contracts\View\Factory|\Illuminate\View\View|mixed
     */
    public function showStepForm()
    {
        return view(
            'installer::steps.requirements', [
                'requirements' => Installer::checkServerRequirements(),
            ]
        );
    }

    /**
     * @return \Illuminate\Http\RedirectResponse
     */
    public function saveStepData()
    {
        $result = Installer::checkServerRequirements();

        if ($result['checking_result']) {
            Installer::completeStep(Installer::REQUIREMENTS_STEP);

            return Redirect::route('evapps.installer.' . Installer::LICENSE_KEY_STEP . '-show-step-form');
        } else {
            return Redirect::back();
        }
    }
}
