<?php

namespace evApps\Installer\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Redirect;

/**
 * Class LocaleController
 *
 * @package evApps\Installer\app\Http\Controllers
 */
class LocaleController extends Controller
{

    /**
     * @param string $locale
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function setLocale(string $locale)
    {
        $response = Redirect::back();

        if (in_array($locale, Config::get('evapps.installer.locales'))) {
            return $response->withCookie(
                Cookie::forever(
                    'locale',
                    $locale,
                    '/' . config('evapps.installer.route_prefix') . '/'
                )
            );
        }

        return $response;
    }
}
