<?php

namespace evApps\Installer\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Redirect;

/**
 * Class CookiesController
 *
 * @package evApps\Installer\app\Http\Controllers
 */
class CookiesController extends Controller
{

    /**
     * @return \Illuminate\Http\RedirectResponse
     */
    public function clearCookies()
    {
        // Forget all old cookies
        foreach (Cookie::get() as $cookie => $value) {
            Cookie::queue(Cookie::forget($cookie));
        }

        return Redirect::back()->send();
    }
}
