<?php

namespace evApps\Installer\app\Http\Controllers;

use evApps\Installer\app\Http\Requests\AdminRequest;
use evApps\Installer\app\Http\Utilities\Installer;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Redirect;

/**
 * Class AdminController
 *
 * @package evApps\Installer\app\Http\Controllers
 */
class AdminController extends Controller
{

    /**
     * @return array|\Illuminate\Contracts\View\Factory|\Illuminate\View\View|mixed
     */
    public function showStepForm()
    {
        return view('installer::steps.admin');
    }

    /**
     * @param \evApps\Installer\app\Http\Requests\AdminRequest $request
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function saveStepData(AdminRequest $request)
    {
        $encryptedPassword = bcrypt($request->input('password'));

        if (Installer::createAdmin(
            $request->input('name'),
            $request->input('email'),
            $encryptedPassword
        )) {
            Installer::saveStepData(Installer::ADMIN_STEP, [
                'name' => $request->input('name'),
                'email' => $request->input('email'),
                'password' => $encryptedPassword,
            ]);

            Installer::completeStep(Installer::ADMIN_STEP);

            return Redirect::route('evapps.installer.' . Installer::FINISH_STEP . '-show-step-form');
        } else {
            return Redirect::back()
                ->withErrors(__('installer::admin.not_created'))
                ->withInput();
        }
    }
}
