<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Cache;
use App\Models\PermissionManager\Permission;
use App\Models\PermissionManager\Role;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // first reset cached roles and permissions
        Cache::forget('spatie.permission.cache');

        // create roles and assign existing permissions
        $current_role = Role::where('name', 'консьерж')->first();

        if ($current_role) {
            $role = $current_role;
        } else {
            $role = Role::create(['name' => 'консьерж']);
        }

        $role->givePermissionTo(Permission::FULL_ACCESS);

        request()->cookies->set('object', \App\Models\Building::first()->id);

        // give special permission for all existing users
        \App\Models\User::all()->each(function ($user){
            $user->givePermissionTo(Permission::FULL_ACCESS);
        });
    }
}
