<?php

use Illuminate\Database\Seeder;

class QuizResultTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $object_id = \App\Models\Building::first()->id;
        $quiz = [
            'fields' => [
                'object_id' => $object_id,
                'title' => 'Опрос с результатами',
                'question' => 'Устраивает ли вас работа нашего лифта?',
                'free_answer' => true,
                'multiple' => true,
                'start_at' => date('Y-m-d H:i:s'),
                'end_at' => date('Y-m-d H:i:s', strtotime('+6 month')),
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            'variants' => [
                [
                    'text' => 'Да',
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ],
                [
                    'text' => 'Нет',
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ],
                [
                    'text' => 'Не уверен',
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ],
            ]
        ];


        // let's create quiz
        $quiz_id = DB::table('quizzes')->insertGetId($quiz['fields']);
        $variants = [];
        foreach ($quiz['variants'] as $variant) {
            $variants[] = DB::table('quiz_answer')->insertGetId(array_merge(['quiz_id' => $quiz_id], $variant));
        }

        $user = [
            'name' => 'test',
            'email' => 'test@test.com',
            'password' => Hash::make('123456'),
        ];

        // let's create user
        $user_id = DB::table('users')->insertGetId($user);

        $result = [
            'quiz_id' => $quiz_id,
            'user_id' => $user_id,
        ];

        foreach ($variants as $variant_id) {
            $val = rand(1, 20);
            for ($i = 0; $i <= $val; $i++) {
                DB::table('quiz_result')->insert(array_merge(['quiz_answer_id' => $variant_id], $result));
            }
        }

        $free_variant_length = rand(1, 20);
        for ($i = 0; $i <= $free_variant_length; $i++) {
            DB::table('quiz_result')->insert(array_merge(['free_answer_value' => 'text ' . $i], $result));
        }

    }
}