<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Cache;
use App\Models\PermissionManager\Permission;

class PermissionsWithWeightsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // first reset cached roles and permissions
        Cache::forget('spatie.permission.cache');

        $permissionsWithWeights = [[
            'name'   => Permission::FULL_ACCESS,
            'weight' => Permission::FULL_ACCESS_WEIGHT,
            'group_id' => Permission::FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::USER_CREATE_ACCESS,
            'weight' => Permission::USER_CREATE_ACCESS_WEIGHT,
            'group_id' => Permission::USER_CREATE_ACCESS_GROUP
        ], [
            'name'   => Permission::USER_VIEW_FULL_ACCESS,
            'weight' => Permission::USER_VIEW_FULL_ACCESS_WEIGHT,
            'group_id' => Permission::USER_VIEW_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::USER_VIEW_LIMITED_ACCESS,
            'weight' => Permission::USER_VIEW_LIMITED_ACCESS_WEIGHT,
            'group_id' => Permission::USER_VIEW_LIMITED_ACCESS_GROUP
        ], [
            'name'   => Permission::USER_EDIT_FULL_ACCESS,
            'weight' => Permission::USER_EDIT_FULL_ACCESS_WEIGHT,
            'group_id' => Permission::USER_EDIT_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::USER_EDIT_ACCESS,
            'weight' => Permission::USER_EDIT_ACCESS_WEIGHT,
            'group_id' => Permission::USER_EDIT_ACCESS_GROUP
        ], [
            'name'   => Permission::USER_DELETE_ACCESS,
            'weight' => Permission::USER_DELETE_ACCESS_WEIGHT,
            'group_id' => Permission::USER_DELETE_ACCESS_GROUP
        ], [
            'name'   => Permission::PERMISSIONS_VIEW_ACCESS,
            'weight' => Permission::PERMISSIONS_VIEW_ACCESS_WEIGHT,
            'group_id' => Permission::PERMISSIONS_VIEW_ACCESS_GROUP
        ], [
            'name'   => Permission::ROLES_CREATE_ACCESS,
            'weight' => Permission::ROLES_CREATE_ACCESS_WEIGHT,
            'group_id' => Permission::ROLES_CREATE_ACCESS_GROUP
        ], [
            'name'   => Permission::ROLES_VIEW_ACCESS,
            'weight' => Permission::ROLES_VIEW_ACCESS_WEIGHT,
            'group_id' => Permission::ROLES_VIEW_ACCESS_GROUP
        ], [
            'name'   => Permission::ROLES_EDIT_ACCESS,
            'weight' => Permission::ROLES_EDIT_ACCESS_WEIGHT,
            'group_id' => Permission::ROLES_EDIT_ACCESS_GROUP
        ], [
            'name'   => Permission::ROLES_DELETE_ACCESS,
            'weight' => Permission::ROLES_DELETE_ACCESS_WEIGHT,
            'group_id' => Permission::ROLES_DELETE_ACCESS_GROUP
        ], [
            'name'   => Permission::APARTMENTS_CREATE_ACCESS,
            'weight' => Permission::APARTMENTS_CREATE_ACCESS_WEIGHT,
            'group_id' => Permission::APARTMENTS_CREATE_ACCESS_GROUP
        ], [
            'name'   => Permission::APARTMENTS_VIEW_LIMITED_ACCESS,
            'weight' => Permission::APARTMENTS_VIEW_LIMITED_ACCESS_WEIGHT,
            'group_id' => Permission::APARTMENTS_VIEW_LIMITED_ACCESS_GROUP
        ], [
            'name'   => Permission::APARTMENTS_VIEW_FULL_ACCESS,
            'weight' => Permission::APARTMENTS_VIEW_FULL_ACCESS_WEIGHT,
            'group_id' => Permission::APARTMENTS_VIEW_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::APARTMENTS_EDIT_ACCESS,
            'weight' => Permission::APARTMENTS_EDIT_ACCESS_WEIGHT,
            'group_id' => Permission::APARTMENTS_EDIT_ACCESS_GROUP
        ], [
            'name'   => Permission::CAMERAS_CREATE_ACCESS,
            'weight' => Permission::CAMERAS_CREATE_ACCESS_WEIGHT,
            'group_id' => Permission::CAMERAS_CREATE_ACCESS_GROUP
        ], [
            'name'   => Permission::CAMERAS_VIEW_LIMITED_ACCESS,
            'weight' => Permission::CAMERAS_VIEW_LIMITED_ACCESS_WEIGHT,
            'group_id' => Permission::CAMERAS_VIEW_LIMITED_ACCESS_GROUP
        ], [
            'name'   => Permission::CAMERAS_EDIT_ACCESS,
            'weight' => Permission::CAMERAS_EDIT_ACCESS_WEIGHT,
            'group_id' => Permission::CAMERAS_EDIT_ACCESS_GROUP
        ], [
            'name'   => Permission::CAMERAS_DELETE_ACCESS,
            'weight' => Permission::CAMERAS_DELETE_ACCESS_WEIGHT,
            'group_id' => Permission::CAMERAS_DELETE_ACCESS_GROUP
        ], [
            'name'   => Permission::CALLING_PANELS_CREATE_ACCESS,
            'weight' => Permission::CALLING_PANELS_CREATE_ACCESS_WEIGHT,
            'group_id' => Permission::CALLING_PANELS_CREATE_ACCESS_GROUP
        ], [
            'name'   => Permission::CALLING_PANELS_VIEW_LIMITED_ACCESS,
            'weight' => Permission::CALLING_PANELS_VIEW_LIMITED_ACCESS_WEIGHT,
            'group_id' => Permission::CALLING_PANELS_VIEW_LIMITED_ACCESS_GROUP
        ], [
            'name'   => Permission::CALLING_PANELS_EDIT_ACCESS,
            'weight' => Permission::CALLING_PANELS_EDIT_ACCESS_WEIGHT,
            'group_id' => Permission::CALLING_PANELS_EDIT_ACCESS_GROUP
        ], [
            'name'   => Permission::CALLING_PANELS_DELETE_ACCESS,
            'weight' => Permission::CALLING_PANELS_DELETE_ACCESS_WEIGHT,
            'group_id' => Permission::CALLING_PANELS_DELETE_ACCESS_GROUP
        ], [
            'name'   => Permission::ANNOUNCEMENT_FULL_ACCESS,
            'weight' => Permission::ANNOUNCEMENT_FULL_ACCESS_WEIGHT,
            'group_id' => Permission::ANNOUNCEMENT_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::REVIEWS_FULL_ACCESS,
            'weight' => Permission::REVIEWS_FULL_ACCESS_WEIGHT,
            'group_id' => Permission::REVIEWS_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::NOTIFICATIONS_FULL_ACCESS,
            'weight' => Permission::NOTIFICATIONS_FULL_ACCESS_WEIGHT,
            'group_id' => Permission::NOTIFICATIONS_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::QUIZES_FULL_ACCESS,
            'weight' => Permission::QUIZES_FULL_ACCESS_WEIGHT,
            'group_id' => Permission::QUIZES_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::QUIZ_TEMPLATES_ACCESS,
            'weight' => Permission::QUIZ_TEMPLATES_ACCESS_WEIGHT,
            'group_id' => Permission::QUIZ_TEMPLATES_ACCESS_GROUP
        ], [
            'name'   => Permission::MESSAGE_TEMPLATES_ACCESS,
            'weight' => Permission::MESSAGE_TEMPLATES_ACCESS_WEIGHT,
            'group_id' => Permission::MESSAGE_TEMPLATES_ACCESS_GROUP
        ], [
            'name'   => Permission::CLAIM_TYPES_FULL_ACCESS,
            'weight' => Permission::CLAIM_TYPES_FULL_ACCESS_WEIGHT,
            'group_id' => Permission::CLAIM_TYPES_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::CLAIM_TYPES_VIEW_ACCESS,
            'weight' => Permission::CLAIM_TYPES_VIEW_ACCESS_WEIGHT,
            'group_id' => Permission::CLAIM_TYPES_VIEW_ACCESS_GROUP
        ], [
            'name'   => Permission::CLAIMS_ALL_ACCESS,
            'weight' => Permission::CLAIMS_ALL_ACCESS_WEIGHT,
            'group_id' => Permission::CLAIMS_ALL_ACCESS_GROUP
        ], [
            'name'   => Permission::CLAIMS_BY_TYPE_ACCESS,
            'weight' => Permission::CLAIMS_BY_TYPE_ACCESS_WEIGHT,
            'group_id' => Permission::CLAIMS_BY_TYPE_ACCESS_GROUP
        ], [
            'name'   => Permission::AUTHORIZED_USERS_FULL_ACCESS,
            'weight' => Permission::AUTHORIZED_USERS_FULL_ACCESS_WEIGHT,
            'group_id' => Permission::AUTHORIZED_USERS_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::AUTHORIZED_USERS_LIMITED_ACCESS,
            'weight' => Permission::AUTHORIZED_USERS_LIMITED_ACCESS_WEIGHT,
            'group_id' => Permission::AUTHORIZED_USERS_LIMITED_ACCESS_GROUP
        ], [
            'name'   => Permission::SETTINGS_VIEW_ACCESS,
            'weight' => Permission::SETTINGS_VIEW_ACCESS_WEIGHT,
            'group_id' => Permission::SETTINGS_VIEW_ACCESS_GROUP
        ], [
            'name'   => Permission::SETTINGS_EDIT_ACCESS,
            'weight' => Permission::SETTINGS_EDIT_ACCESS_WEIGHT,
            'group_id' => Permission::SETTINGS_EDIT_ACCESS_GROUP
        ]];

        foreach ($permissionsWithWeights as $permissionWithWeight) {
            Permission::firstOrCreate(
                [
                    'name' => $permissionWithWeight['name'],
                ],
                [
                    'weight' => $permissionWithWeight['weight'],
                    'group_id' => $permissionWithWeight['group_id'],
                ]
            );
        }
    }
}
