<?php

use Illuminate\Database\Seeder;
use App\Models\PermissionManager\Permission;

class HelpSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->permissionUsersUpdate();
        $this->rolesUsersFix();
    }

    /**
     * Исправление состояния базы данных, при котором пользователи с полным доступом имеют лишние права
     */
    protected function permissionUsersUpdate()
    {
        // Найти идентификатор полного достуsпа
        $full_access_id = Permission::where('name', Permission::FULL_ACCESS)->first()->id;
        // Выбрать всех пользователей, у которых права на полный доступ
        $permissions = DB::table('permission_users')
            ->select('user_id', 'object_id')
            ->where('permission_id', $full_access_id)
            ->get();

        foreach ($permissions as $permission) {
            DB::table('permission_users')
                ->where('user_id', $permission->user_id)
                ->where('object_id', $permission->object_id)
                ->where('permission_id', '!=', $full_access_id)
                ->delete();
        }
    }

    /**
     * Исправление состояния базы данных, при котором пользователи с полным доступом имеют лишние права
     */
    protected function rolesUsersFix()
    {
        // Найти идентификатор полного достуsпа
        $full_access_id = Permission::where('name', Permission::FULL_ACCESS)->first()->id;

        // Выбрать всех пользователей, у которых права на полный доступ
        $permissions = DB::table('permission_roles')
            ->select('role_id')
            ->where('permission_id', $full_access_id)
            ->get();
        
        foreach ($permissions as $permission) {
            DB::table('permission_roles')
                ->where('role_id', $permission->role_id)
                ->where('permission_id', '!=', $full_access_id)
                ->delete();
        }
    }
}
