<?php

use Illuminate\Database\Seeder;

class CamerasTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $object = \App\Models\Building::first()->id;
        $cameras = [[
            'name'     => 'Камера на парковке',
            'rtsp_link'=> 'rtsp://127.0.0.1/cameras/camera_1.mp4',
        ],[
            'name'     => 'Камера у подъезда',
            'rtsp_link'=> 'rtsp://127.0.0.1/cameras/camera_2.mp4',
        ],[
            'name'     => 'Камера у шлагбаума',
            'rtsp_link'=> 'rtsp://127.0.0.1/cameras/camera_3.mp4',
        ]];

        $now = date('Y-m-d H:i:s');

        $timestamps = [
            'created_at' => $now,
            'updated_at' => $now,
            'object_id' => $object
        ];

        // let's create cameras
        foreach ($cameras as $camera) {
            DB::table('cameras')->insert(array_merge($camera, $timestamps));
        }
    }
}
