<?php

use Illuminate\Database\Seeder;

class CallingPanelsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $calling_panels = [[
            'name' => 'Вызывная панель 1',
            'sip_number' => '12340',
            'rtsp_link' => 'rtsp://127.0.0.1/panel/1',
            'dtmf_1' => 'dtmf#1',
        ], [
            'name' => 'Вызывная панель 2',
            'sip_number' => '12341',
            'rtsp_link' => 'rtsp://127.0.0.1/panel/2',
            'dtmf_1' => 'dtmf#1',
            'dtmf_2' => 'dtmf#2',
        ], [
            'name' => 'Вызывная панель 3',
            'sip_number' => '12342',
            'login' => 'panel3',
            'password' => 'password',
            'ip_address' => '127.0.0.1',
            'port' => '4321',
            'dtmf_1' => 'dtmf#1',
            'dtmf_2' => 'dtmf#2',
        ]];

        $now = date('Y-m-d H:i:s');
        $object = \App\Models\Building::first()->id;

        $timestamps = [
            'created_at' => $now,
            'updated_at' => $now,
            'object_id' => $object
        ];

        foreach ($calling_panels as $calling_panel) {
            DB::table('calling_panels')->insert(array_merge($calling_panel, $timestamps));
        }
    }
}
