<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddIncrementingColumnInApartmentSipNumbersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('apartment_sip_numbers', function (Blueprint $table) {
            $table->dropUnique('sip_numbers_sip_number_unique');
            $table->dropPrimary();
        });

        Schema::table('apartment_sip_numbers', function (Blueprint $table) {
            $table->increments('id')->first();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('apartment_sip_numbers', function (Blueprint $table) {
            $table->dropColumn('id');
        });

        Schema::table('apartment_sip_numbers', function (Blueprint $table) {
            $table->string('sip_number', 255)->change();
            $table->primary('sip_number');
            $table->unique('sip_number', 'sip_numbers_sip_number_unique');
        });
    }
}