<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddEntryToSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('settings', function (Blueprint $table) {
            DB::table('settings')->insert([
                'key'         => 'acs_users',
                'name'        => 'Администраторы сервера кодов доступа',
                'description' => 'Разрешить ли удаленное создание администраторов',
                'value'       => 1,
                'field'       => '{"name":"value","label":"Разрешить ли удаленное создание администраторов (0/1)","type":"number"}',
                'active'      => 1,
            ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('settings', function (Blueprint $table) {
            DB::table('settings')->where('key', 'acs_users')->delete();
        });
    }
}
