<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use App\Models\PermissionManager\Permission;
use Illuminate\Support\Facades\Cache;

class AddGroupIdColumnInToPermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('permissions', function (Blueprint $table) {
            $table->unsignedInteger('group_id')->after('weight');
        });

        $permissions = [[
            'name'   => Permission::FULL_ACCESS,
            'group_id' => Permission::FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::USER_CREATE_ACCESS,
            'group_id' => Permission::USER_CREATE_ACCESS_GROUP
        ], [
            'name'   => Permission::USER_VIEW_FULL_ACCESS,
            'group_id' => Permission::USER_VIEW_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::USER_VIEW_LIMITED_ACCESS,
            'group_id' => Permission::USER_VIEW_LIMITED_ACCESS_GROUP
        ], [
            'name'   => Permission::USER_EDIT_FULL_ACCESS,
            'group_id' => Permission::USER_EDIT_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::USER_EDIT_ACCESS,
            'group_id' => Permission::USER_EDIT_ACCESS_GROUP
        ], [
            'name'   => Permission::USER_DELETE_ACCESS,
            'group_id' => Permission::USER_DELETE_ACCESS_GROUP
        ], [
            'name'   => Permission::PERMISSIONS_VIEW_ACCESS,
            'group_id' => Permission::PERMISSIONS_VIEW_ACCESS_GROUP
        ], [
            'name'   => Permission::ROLES_CREATE_ACCESS,
            'group_id' => Permission::ROLES_CREATE_ACCESS_GROUP
        ], [
            'name'   => Permission::ROLES_VIEW_ACCESS,
            'group_id' => Permission::ROLES_VIEW_ACCESS_GROUP
        ], [
            'name'   => Permission::ROLES_EDIT_ACCESS,
            'group_id' => Permission::ROLES_EDIT_ACCESS_GROUP
        ], [
            'name'   => Permission::ROLES_DELETE_ACCESS,
            'group_id' => Permission::ROLES_DELETE_ACCESS_GROUP
        ], [
            'name'   => Permission::APARTMENTS_CREATE_ACCESS,
            'group_id' => Permission::APARTMENTS_CREATE_ACCESS_GROUP
        ], [
            'name'   => Permission::APARTMENTS_VIEW_LIMITED_ACCESS,
            'group_id' => Permission::APARTMENTS_VIEW_LIMITED_ACCESS_GROUP
        ], [
            'name'   => Permission::APARTMENTS_VIEW_FULL_ACCESS,
            'group_id' => Permission::APARTMENTS_VIEW_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::APARTMENTS_EDIT_ACCESS,
            'group_id' => Permission::APARTMENTS_EDIT_ACCESS_GROUP
        ], [
            'name'   => Permission::CAMERAS_CREATE_ACCESS,
            'group_id' => Permission::CAMERAS_CREATE_ACCESS_GROUP
        ], [
            'name'   => Permission::CAMERAS_VIEW_LIMITED_ACCESS,
            'group_id' => Permission::CAMERAS_VIEW_LIMITED_ACCESS_GROUP
        ], [
            'name'   => Permission::CAMERAS_EDIT_ACCESS,
            'group_id' => Permission::CAMERAS_EDIT_ACCESS_GROUP
        ], [
            'name'   => Permission::CAMERAS_DELETE_ACCESS,
            'group_id' => Permission::CAMERAS_DELETE_ACCESS_GROUP
        ], [
            'name'   => Permission::CALLING_PANELS_CREATE_ACCESS,
            'group_id' => Permission::CALLING_PANELS_CREATE_ACCESS_GROUP
        ], [
            'name'   => Permission::CALLING_PANELS_VIEW_LIMITED_ACCESS,
            'group_id' => Permission::CALLING_PANELS_VIEW_LIMITED_ACCESS_GROUP
        ], [
            'name'   => Permission::CALLING_PANELS_EDIT_ACCESS,
            'group_id' => Permission::CALLING_PANELS_EDIT_ACCESS_GROUP
        ], [
            'name'   => Permission::CALLING_PANELS_DELETE_ACCESS,
            'group_id' => Permission::CALLING_PANELS_DELETE_ACCESS_GROUP
        ], [
            'name'   => Permission::ANNOUNCEMENT_FULL_ACCESS,
            'group_id' => Permission::ANNOUNCEMENT_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::REVIEWS_FULL_ACCESS,
            'group_id' => Permission::REVIEWS_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::NOTIFICATIONS_FULL_ACCESS,
            'group_id' => Permission::NOTIFICATIONS_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::QUIZES_FULL_ACCESS,
            'group_id' => Permission::QUIZES_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::QUIZ_TEMPLATES_ACCESS,
            'group_id' => Permission::QUIZ_TEMPLATES_ACCESS_GROUP
        ], [
            'name'   => Permission::MESSAGE_TEMPLATES_ACCESS,
            'group_id' => Permission::MESSAGE_TEMPLATES_ACCESS_GROUP
        ], [
            'name'   => Permission::CLAIM_TYPES_FULL_ACCESS,
            'group_id' => Permission::CLAIM_TYPES_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::CLAIM_TYPES_VIEW_ACCESS,
            'group_id' => Permission::CLAIM_TYPES_VIEW_ACCESS_GROUP
        ], [
            'name'   => Permission::CLAIMS_ALL_ACCESS,
            'group_id' => Permission::CLAIMS_ALL_ACCESS_GROUP
        ], [
            'name'   => Permission::CLAIMS_BY_TYPE_ACCESS,
            'group_id' => Permission::CLAIMS_BY_TYPE_ACCESS_GROUP
        ], [
            'name'   => Permission::AUTHORIZED_USERS_FULL_ACCESS,
            'group_id' => Permission::AUTHORIZED_USERS_FULL_ACCESS_GROUP
        ], [
            'name'   => Permission::AUTHORIZED_USERS_LIMITED_ACCESS,
            'group_id' => Permission::AUTHORIZED_USERS_LIMITED_ACCESS_GROUP
        ], [
            'name'   => Permission::SETTINGS_VIEW_ACCESS,
            'group_id' => Permission::SETTINGS_VIEW_ACCESS_GROUP
        ], [
            'name'   => Permission::SETTINGS_EDIT_ACCESS,
            'group_id' => Permission::SETTINGS_EDIT_ACCESS_GROUP
        ]];

        foreach ($permissions as $permission) {
            DB::update('UPDATE permissions SET permissions.group_id = ? WHERE permissions.name = ?', [$permission['group_id'], $permission['name']]);
        }

        Schema::table('permissions', function (Blueprint $table) {
            $table->unsignedInteger('group_id')->nullable(false)->change();
            $table->foreign('group_id')->references('id')->on('permissions_groups');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('permissions', function (Blueprint $table) {
            $table->dropForeign('permissions_group_id_foreign');
            $table->dropColumn('group_id');
        });
    }
}